## ----load data, results='hide', echo=FALSE, message=FALSE----------------
rm(list=ls(all=TRUE))

# Libraries ================================================
library(plyr) # for split-app2ly functions
library(ggplot2) # for plotting
library(reshape2) # for data manipulation
library(mgcv) # for GAMs
library(openxlsx) # for reading Excel workbooks

setwd("~/Desktop/Dropbox/SMRU/MSFD/IA2017v2/Draft 20160721 v1.02") 
# set to your own working directory

wb <- loadWorkbook("20160721_Table_B_survey_data.xlsx")
names(wb)

## ----hg pup sum, results='hide', echo=FALSE, message=FALSE---------------
# Need sum pup pro across NL bit of Wadden Sea 
# Grey seal colony data ============================================================
head(coldistrib <- readWorkbook(wb,"M5_colonies_HG",check.names=FALSE))
str(coldistrib); summary(coldistrib)
coldistrib$Year <- as.integer(coldistrib$Year)

# Clean up and check ===============================================================
  # restrict to 1992:2014
  unique(coldistrib$Country); max(coldistrib$Year); min(coldistrib$Year)
  unique(coldistrib$Assessment_unit)
   coldistrib <- coldistrib[which(coldistrib$Year > 1991 & coldistrib$Year < 2015),]
   head(coldistrib)
   
   # count data comes in form of counts or pup production: 
   coldistrib$Count <- with(coldistrib,ifelse(is.na(Pups.count)==TRUE,Pup.production,Pups.count))
   
  ddply(coldistrib,c("Assessment_unit","Year"),summarise, count = sum(Count), n = length(Count))
    # add the Norway summary counts and Wadden Sea NL counts to 'pups' worksheet
  
  # create a new column of 'reporting periods'. Starting with most recent year for which we have data from all CPs and work backwards in increments of 6 years
  coldistrib$Period <- with(coldistrib ,ifelse(Year %in% max(Year-6+1):max(Year),paste(paste(max(Year-6+1)),paste(max(Year)),sep="-"),ifelse(Year %in% max(Year-12+1):max(Year-6),paste(paste(max(Year-12+1)),paste(max(Year-6)),sep="-"),ifelse(Year %in% max(Year-18+1):max(Year-12),paste(paste(max(Year-18+1)),paste(max(Year-12)),sep="-"),ifelse(Year %in% max(Year-24+1):max(Year-18),paste(paste(max(Year-24+1)),paste(max(Year-18)),sep="-"),NA)))))


## ----set up, results='hide', echo=FALSE, message=FALSE-------------------
# Grey seal pup data ==============================================================
head(pups <- readWorkbook(wb,"M5_pups_HG",check.names=FALSE))
str(pups); summary(pups)
pups$Year <- as.integer(pups$Year)
  
  # Clean up and check =============================================
  # restrict to pupping season counts
  unique(pups$Month); unique(pups$Country) 
  min(unique(pups$Year)); max(unique(pups$Year))
  # restrict to 1992-2014
  pups <- pups[which(pups$Year > 1991 & pups$Year < 2015),]
   head(pups)
    # NB: UK data for 2014 only available after SCOS 2016 (in September)
   
  # summarise: split by AU and year and caluclate the sum count, and the countries we have data from for that year and AU
 (pups_sum <- ddply(pups,c("Assessment_unit","Year"),summarise, n.count=length(Count), Total=sum(Count)))
    # North coast & Orkney only AU with 2 areas that needed summing (N coast mainland + Orkney) 
  
    # create a new column of 'reporting periods'. Starting with most recent year for which we have data from all CPs and work backwards in increments of 6 years
  pups_sum$Period <- with(pups_sum ,ifelse(Year %in% max(Year-6+1):max(Year),paste(paste(max(Year-6+1)),paste(max(Year)),sep="-"),ifelse(Year %in% max(Year-12+1):max(Year-6),paste(paste(max(Year-12+1)),paste(max(Year-6)),sep="-"),ifelse(Year %in% max(Year-18+1):max(Year-12),paste(paste(max(Year-18+1)),paste(max(Year-12)),sep="-"),ifelse(Year %in% max(Year-24+1):max(Year-18),paste(paste(max(Year-24+1)),paste(max(Year-18)),sep="-"),NA)))))


## ----plot pups, results='hide', echo=FALSE, message=FALSE----------------
  # Plot
  ggplot(pups_sum) + geom_point(aes(Year,Total,col=Period)) + facet_wrap(~Assessment_unit) + theme(axis.text.x = element_text(angle = 45,hjust=1)) + ggtitle("Grey seal pups")

# Assessment Units
  AU <- unique(pups_sum$Assessment_unit)
  
   # Create space for each result
  (growth <- data.frame(AU=AU,
    t1rate=rep(NA,length(AU)), # average annual rate of growth
    t1U=rep(NA,length(AU)), # upper 80% CI on annual rate
    t1L=rep(NA,length(AU)), # lower 80% CI on annual rate
    t1N=rep(NA,length(AU)), # number of survey years in period
    t2delta=rep(NA,length(AU)), # net % change in abundance since reference year, from model
    t2deltaU=rep(NA,length(AU)), # upper 80% CI on net change
    t2deltaL=rep(NA,length(AU)), # lower 80% CI on net change
    t2deltaOBS=rep(NA,length(AU)), # observed net change since reference
    t2N=rep(NA,length(AU)), # number of survey years since reference year
    baselineyr=rep(NA,length(AU)),
    last.count = rep(NA,length(AU)))) # most recent count

  ddply(pups_sum,"Assessment_unit",summarise,n=length(unique(Year)))
    # assess all where n = or > 4

## ----east scotland, results='hide', echo=FALSE, message=FALSE------------
# East Scotland
data <- "East Scotland"
Data <- pups_sum[which(pups_sum$Assessment_unit == data),]
ggplot(Data) + geom_point(aes(Year,Total,col=Period)) 

# Target 1: annual population growth rate in previous reporting round 
  t1 <- glm(Total~Year, data=subset(Data,Period=="2009-2014"),family=quasipoisson)
  summary(t1) 
  growth[growth$AU==data,"t1rate"] <- (summary(t1)$coef[2])*100
  growth[growth$AU==data,"t1U"] <- confint(t1,parm="Year",level=0.8)[2]*100
  growth[growth$AU==data,"t1L"] <- confint(t1,parm="Year",level=0.8)[1]*100
  growth[growth$AU==data,"t1N"] <- nobs(t1)

# Target 2: change in abundance since reference (1992 or earliest) year
  # Model(s)  
  t2<- gam(Total~s(Year,k=4),data=Data,family=quasipoisson) 

  # Fit(s)  
  yr<-data.frame(Year=min(Data$Year):max(Data$Year))
  pt2<-predict(t2,se=TRUE,type="response",newdata=yr)
  (T2<- data.frame(yr,pt2))
  # 80% confidence interval approximately 1.28 * s.e.
  (T2$upper80 <- T2$fit + 1.28*T2$se.fit) # upper 80% confidence limit
  (T2$lower80 <- T2$fit - 1.28*T2$se.fit) # lower 80% confidence limit
  
  # Calculate observed and mean fitted delta change
    growth[growth$AU==data,"t2deltaOBS"] <- with(Data,(((tail(Total,1)-head(Total,1))/head(Total,1)*100)))
    growth[growth$AU==data,"t2delta"] <- ((tail(T2$fit,1)-head(T2$fit,1))/head(T2$fit,1)*100)
    growth[growth$AU==data,"t2deltaU"] <- ((tail(T2$upper80,1)-head(T2$lower80,1))/head(T2$lower80,1)*100) 
  growth[growth$AU==data,"t2deltaL"] <- ((tail(T2$lower80,1)-head(T2$upper80,1))/head(T2$upper80,1)*100) 
    growth[growth$AU==data,"t2N"] <- nobs(t2)
    growth[growth$AU==data,"baselineyr"] <- min(Data$Year)
    growth[growth$AU==data,"last.count"] <- Data[which(Data$Year==max(Data$Year)),"Total"]
    growth
   
# Figure
  yr1 <-data.frame(Year=min(Data[which(Data$Period=="2009-2014"),"Year"]):max(Data[which(Data$Period=="2009-2014"),"Year"]))
  pt1<-predict(t1,se=TRUE,type="response",newdata=yr1)
  (T1 <- data.frame(yr1,pt1))

  ESfig <- ggplot(Data) + 
    geom_line(data=T1,aes(Year,fit), lty="dotdash", lwd=1) +
    geom_ribbon(data=T1,aes(Year,ymax=fit+1.28*se.fit,ymin=fit-1.28*se.fit), fill="light blue", alpha=0.75) +
  geom_line(data=T2,aes(Year,fit), lty="dotted", lwd=1) +
    geom_ribbon(data=T2,aes(Year,ymax=fit+1.28*se.fit,ymin=fit-1.28*se.fit), fill="grey", alpha=0.5) +
    geom_point(data=Data, aes(x=Year, y=Total, col=Period)) + scale_x_continuous(limits=c(1992,2014),breaks=c(1995,2000,2005,2010)) + 
    scale_color_manual(values=c("1991-1996"="#e7298a","1997-2002"="#7570b3", "2003-2008"="#d95f02","2009-2014"="#1b9e77")) + 
    ylab("Grey seal moult count") + xlab("") +
    ggtitle(data) + 
    theme_bw() + theme(legend.position="none") 
  ESfig

## ----moray firth, results='hide', echo=FALSE, message=FALSE--------------
# Moray Firth 
data <- "Moray Firth"
Data <- pups_sum[which(pups_sum$Assessment_unit == data),]
ggplot(Data) + geom_point(aes(Year,Total,col=Period)) 
 
# Target 1: annual population growth rate in previous reporting round 
     growth[growth$AU==data,"t1N"] <- length(which(Data$Period=="2009-2014"))

# Target 2: change in abundance since reference (1992 or earliest) year
  # Model(s)  
  t2 <- gam(Total ~ s(Year,k=4), data=Data, family=quasipoisson)

  # Fit(s)  
  yr<-data.frame(Year=min(Data$Year):max(Data$Year))
  pt2<-predict(t2,se=TRUE,type="response",newdata=yr)
  (T2<- data.frame(yr,pt2))
  # 80% confidence interval approximately 1.28 * s.e.
  (T2$upper80 <- T2$fit + 1.28*T2$se.fit) # upper 80% confidence limit
  (T2$lower80 <- T2$fit - 1.28*T2$se.fit) # lower 80% confidence limit
  
  # Calculate observed and mean fitted delta change
    growth[growth$AU==data,"t2deltaOBS"] <- with(Data,(((tail(Total,1)-head(Total,1))/head(Total,1)*100)))
    growth[growth$AU==data,"t2delta"] <- ((tail(T2$fit,1)-head(T2$fit,1))/head(T2$fit,1)*100)
    growth[growth$AU==data,"t2deltaU"] <- ((tail(T2$upper80,1)-head(T2$lower80,1))/head(T2$lower80,1)*100) 
  growth[growth$AU==data,"t2deltaL"] <- ((tail(T2$lower80,1)-head(T2$upper80,1))/head(T2$upper80,1)*100) 
    growth[growth$AU==data,"t2N"] <- nobs(t2)
    growth[growth$AU==data,"baselineyr"] <- min(Data$Year)
    growth[growth$AU==data,"last.count"] <- Data[which(Data$Year==max(Data$Year)),"Total"]
    growth
   
# Figure

  MFfig <- ggplot(Data) + 
    #geom_line(data=T1,aes(Year,fit), lty="dotdash", lwd=1) +
    #geom_ribbon(data=T1,aes(Year,ymax=fit+1.28*se.fit,ymin=fit-1.28*se.fit), fill="light blue", alpha=0.75) +
  geom_line(data=T2,aes(Year,fit), lty="dotted", lwd=1) +
    geom_ribbon(data=T2,aes(Year,ymax=fit+1.28*se.fit,ymin=fit-1.28*se.fit), fill="grey", alpha=0.5) +
    geom_point(data=Data, aes(x=Year, y=Total, col=Period)) + scale_x_continuous(limits=c(1992,2014),breaks=c(1995,2000,2005,2010)) + 
    scale_color_manual(values=c("1991-1996"="#e7298a","1997-2002"="#7570b3", "2003-2008"="#d95f02","2009-2014"="#1b9e77")) + 
    ylab("Grey seal moult count") + xlab("") +
    ggtitle(data) + 
    theme_bw() + theme(legend.position="none") 
  MFfig

## ----orkney, results='hide', echo=FALSE, message=FALSE-------------------
# North Coast & Orkney 
data <- "North Coast & Orkney"
Data <- pups_sum[which(pups_sum$Assessment_unit == data),]
ggplot(Data) + geom_point(aes(Year,Total,col=Period)) 
  
# Target 1: annual population growth rate in previous reporting round 
  t1 <- glm(Total~Year, data=subset(Data,Period=="2009-2014"),family=quasipoisson)
  summary(t1) 
  growth[growth$AU==data,"t1rate"] <- (summary(t1)$coef[2])*100
  growth[growth$AU==data,"t1U"] <- confint(t1,parm="Year",level=0.8)[2]*100
  growth[growth$AU==data,"t1L"] <- confint(t1,parm="Year",level=0.8)[1]*100
  growth[growth$AU==data,"t1N"] <- nobs(t1)

# Target 2: change in abundance since reference (1992 or earliest) year
  # Model(s)  
  t2<- gam(Total ~ s(Year,k=4), data=Data,family=quasipoisson)
  
  # Fit(s)  
  yr<-data.frame(Year=min(Data$Year):max(Data$Year))
  pt2<-predict(t2,se=TRUE,type="response",newdata=yr)
  (T2<- data.frame(yr,pt2))
  # 80% confidence interval approximately 1.28 * s.e.
  (T2$upper80 <- T2$fit + 1.28*T2$se.fit) # upper 80% confidence limit
  (T2$lower80 <- T2$fit - 1.28*T2$se.fit) # lower 80% confidence limit
  
  # Calculate observed and mean fitted delta change
    growth[growth$AU==data,"t2deltaOBS"] <- with(Data,(((tail(Total,1)-head(Total,1))/head(Total,1)*100)))
    growth[growth$AU==data,"t2delta"] <- ((tail(T2$fit,1)-head(T2$fit,1))/head(T2$fit,1)*100)
    growth[growth$AU==data,"t2deltaU"] <- ((tail(T2$upper80,1)-head(T2$lower80,1))/head(T2$lower80,1)*100) 
  growth[growth$AU==data,"t2deltaL"] <- ((tail(T2$lower80,1)-head(T2$upper80,1))/head(T2$upper80,1)*100) 
    growth[growth$AU==data,"t2N"] <- nobs(t2)
    growth[growth$AU==data,"baselineyr"] <- min(Data$Year)
    growth[growth$AU==data,"last.count"] <- Data[which(Data$Year==max(Data$Year)),"Total"]
    growth
   
# Figure
  yr1 <-data.frame(Year=min(Data[which(Data$Period=="2009-2014"),"Year"]):max(Data[which(Data$Period=="2009-2014"),"Year"]))
  pt1<-predict(t1,se=TRUE,type="response",newdata=yr1)
  (T1 <- data.frame(yr1,pt1))

  OKfig <- ggplot(Data) + 
    geom_line(data=T1,aes(Year,fit), lty="dotdash", lwd=1) +
    geom_ribbon(data=T1,aes(Year,ymax=fit+1.28*se.fit,ymin=fit-1.28*se.fit), fill="light blue", alpha=0.75) +
  geom_line(data=T2,aes(Year,fit), lty="dotted", lwd=1) +
    geom_ribbon(data=T2,aes(Year,ymax=fit+1.28*se.fit,ymin=fit-1.28*se.fit), fill="grey", alpha=0.5) +
    geom_point(data=Data, aes(x=Year, y=Total, col=Period)) + scale_x_continuous(limits=c(1992,2014),breaks=c(1995,2000,2005,2010)) + 
    scale_color_manual(values=c("1991-1996"="#e7298a","1997-2002"="#7570b3", "2003-2008"="#d95f02","2009-2014"="#1b9e77")) + 
    ylab("Grey seal moult count") + xlab("") +
    ggtitle(data) + 
    theme_bw() + theme(legend.position="none") 
  OKfig

## ----northeast england-gam, results='hide', echo=FALSE, message=FALSE----
# Northeast England 
data <- "Northeast England"
Data <- pups_sum[which(pups_sum$Assessment_unit == data),]
ggplot(Data) + geom_point(aes(Year,Total,col=Period)) 
  # the ~800 count in 1999 is correct

# Target 1: annual population growth rate in previous reporting round 
  t1 <- glm(Total~Year, data=subset(Data,Period=="2009-2014"),family=quasipoisson)
  summary(t1) 
  growth[growth$AU==data,"t1rate"] <- (summary(t1)$coef[2])*100
  growth[growth$AU==data,"t1U"] <- confint(t1,parm="Year",level=0.8)[2]*100
  growth[growth$AU==data,"t1L"] <- confint(t1,parm="Year",level=0.8)[1]*100
  growth[growth$AU==data,"t1N"] <- nobs(t1)

# Target 2: change in abundance since reference (1992 or earliest) year
  # Model(s)  
  t2 <- gam(Total ~ s(Year), data=Data, family=quasipoisson)
  
  # Fit(s)  
  yr<-data.frame(Year=min(Data$Year):max(Data$Year))
  pt2<-predict(t2,se=TRUE,type="response",newdata=yr)
  (T2<- data.frame(yr,pt2))
  # 80% confidence interval approximately 1.28 * s.e.
  (T2$upper80 <- T2$fit + 1.28*T2$se.fit) # upper 80% confidence limit
  (T2$lower80 <- T2$fit - 1.28*T2$se.fit) # lower 80% confidence limit
  
  # Calculate observed and mean fitted delta change
    growth[growth$AU==data,"t2deltaOBS"] <- with(Data,(((tail(Total,1)-head(Total,1))/head(Total,1)*100)))
    growth[growth$AU==data,"t2delta"] <- ((tail(T2$fit,1)-head(T2$fit,1))/head(T2$fit,1)*100)
    growth[growth$AU==data,"t2deltaU"] <- ((tail(T2$upper80,1)-head(T2$lower80,1))/head(T2$lower80,1)*100) 
  growth[growth$AU==data,"t2deltaL"] <- ((tail(T2$lower80,1)-head(T2$upper80,1))/head(T2$upper80,1)*100) 
    growth[growth$AU==data,"t2N"] <- nobs(t2)
    growth[growth$AU==data,"baselineyr"] <- min(Data$Year)
    growth[growth$AU==data,"last.count"] <- Data[which(Data$Year==max(Data$Year)),"Total"]
    growth
   
# Figure
  yr1 <-data.frame(Year=min(Data[which(Data$Period=="2009-2014"),"Year"]):max(Data[which(Data$Period=="2009-2014"),"Year"]))
  pt1<-predict(t1,se=TRUE,type="response",newdata=yr1)
  (T1 <- data.frame(yr1,pt1))

  NEfig <- ggplot(Data) + 
    geom_line(data=T1,aes(Year,fit), lty="dotdash", lwd=1) +
    geom_ribbon(data=T1,aes(Year,ymax=fit+1.28*se.fit,ymin=fit-1.28*se.fit), fill="light blue", alpha=0.75) +
  geom_line(data=T2,aes(Year,fit), lty="dotted", lwd=1) +
    geom_ribbon(data=T2,aes(Year,ymax=fit+1.28*se.fit,ymin=fit-1.28*se.fit), fill="grey", alpha=0.5) +
    geom_point(data=Data, aes(x=Year, y=Total, col=Period)) + scale_x_continuous(limits=c(1992,2014),breaks=c(1995,2000,2005,2010)) + 
    scale_color_manual(values=c("1991-1996"="#e7298a","1997-2002"="#7570b3", "2003-2008"="#d95f02","2009-2014"="#1b9e77")) + 
    ylab("Grey seal moult count") + xlab("") +
    ggtitle(data) + 
    theme_bw() + theme(legend.position="none") 
  NEfig

## ----south norway, results='hide', echo=FALSE, message=FALSE-------------
# Norwegian west coast, south of 62N 
data <- "Norwegian west coast, south of 62N"
Data <- pups_sum[which(pups_sum$Assessment_unit == data),]
ggplot(Data) + geom_point(aes(Year,Total,col=Period)) # this is Rogaland only

# Target 1: annual population growth rate in previous reporting round 
  # only one count in last period that we have
  # growth[growth$AU==data,"t1rate"] <- paste("data deficient")
     growth[growth$AU==data,"t1N"] <- length(which(Data$Period=="2009-2014"))
     
# Target 2: change in abundance since reference (1992 or earliest) year
  # Model(s)  
  t2 <- glm(Total ~ Year, data=Data, family=quasipoisson)
  summary(t2)
  
  # Fit(s)  
  yr<-data.frame(Year=min(Data$Year):max(Data$Year))
  pt2<-predict(t2,se=TRUE,type="response",newdata=yr)
  (T2<- data.frame(yr,pt2))
  # 80% confidence interval approximately 1.28 * s.e.
  (T2$upper80 <- T2$fit + 1.28*T2$se.fit) # upper 80% confidence limit
  (T2$lower80 <- T2$fit - 1.28*T2$se.fit) # lower 80% confidence limit
  
  # Calculate observed and mean fitted delta change
    growth[growth$AU==data,"t2deltaOBS"] <- with(Data,(((tail(Total,1)-head(Total,1))/head(Total,1)*100)))
    growth[growth$AU==data,"t2delta"] <- ((tail(T2$fit,1)-head(T2$fit,1))/head(T2$fit,1)*100)
    growth[growth$AU==data,"t2deltaU"] <- ((tail(T2$upper80,1)-head(T2$lower80,1))/head(T2$lower80,1)*100) 
  growth[growth$AU==data,"t2deltaL"] <- ((tail(T2$lower80,1)-head(T2$upper80,1))/head(T2$upper80,1)*100) 
    growth[growth$AU==data,"t2N"] <- nobs(t2)
    growth[growth$AU==data,"baselineyr"] <- min(Data$Year)
    growth[growth$AU==data,"last.count"] <- Data[which(Data$Year==max(Data$Year)),"Total"]
    growth
   
# Figure
  SNfig <- ggplot(Data) + 
    #geom_line(data=T1,aes(Year,fit), lty="dotdash", lwd=1) +
    #geom_ribbon(data=T1,aes(Year,ymax=fit+1.28*se.fit,ymin=fit-1.28*se.fit), fill="light blue", alpha=0.75) +
  geom_line(data=T2,aes(Year,fit), lty="dotted", lwd=1) +
    geom_ribbon(data=T2,aes(Year,ymax=fit+1.28*se.fit,ymin=fit-1.28*se.fit), fill="grey", alpha=0.5) +
    geom_point(data=Data, aes(x=Year, y=Total, col=Period)) + scale_x_continuous(limits=c(1992,2014),breaks=c(1995,2000,2005,2010)) + 
    scale_color_manual(values=c("1991-1996"="#e7298a","1997-2002"="#7570b3", "2003-2008"="#d95f02","2009-2014"="#1b9e77")) + 
    ylab("Grey seal moult count") + xlab("") +
    ggtitle(data) + 
    theme_bw() + theme(legend.position="none") 
  SNfig

## ----shetland, results='hide', echo=FALSE, message=FALSE-----------------
# Shetland
data <- "Shetland"
Data <- pups_sum[which(pups_sum$Assessment_unit == data),]
ggplot(Data) + geom_point(aes(Year,Total,col=Period)) 
  
# Target 1: annual population growth rate in previous reporting round 
  t1 <- glm(Total~Year, data=subset(Data,Period=="2009-2014"),family=quasipoisson)
  summary(t1) 
  growth[growth$AU==data,"t1rate"] <- (summary(t1)$coef[2])*100
  growth[growth$AU==data,"t1U"] <- confint(t1,parm="Year",level=0.8)[2]*100
  growth[growth$AU==data,"t1L"] <- confint(t1,parm="Year",level=0.8)[1]*100
  growth[growth$AU==data,"t1N"] <- nobs(t1)

# Target 2: change in abundance since reference (1992 or earliest) year
   t2 <-  gam(Total~s(Year,k=4),data=Data,family=quasipoisson) 

  # Fit(s)  
  yr<-data.frame(Year=min(Data$Year):max(Data$Year))
  pt2<-predict(t2,se=TRUE,type="response",newdata=yr)
  (T2<- data.frame(yr,pt2))
  # 80% confidence interval approximately 1.28 * s.e.
  (T2$upper80 <- T2$fit + 1.28*T2$se.fit) # upper 80% confidence limit
  (T2$lower80 <- T2$fit - 1.28*T2$se.fit) # lower 80% confidence limit
  
  # Calculate observed and mean fitted delta change
    growth[growth$AU==data,"t2deltaOBS"] <- with(Data,(((tail(Total,1)-head(Total,1))/head(Total,1)*100)))
    growth[growth$AU==data,"t2delta"] <- ((tail(T2$fit,1)-head(T2$fit,1))/head(T2$fit,1)*100)
    growth[growth$AU==data,"t2deltaU"] <- ((tail(T2$upper80,1)-head(T2$lower80,1))/head(T2$lower80,1)*100) 
  growth[growth$AU==data,"t2deltaL"] <- ((tail(T2$lower80,1)-head(T2$upper80,1))/head(T2$upper80,1)*100) 
    growth[growth$AU==data,"t2N"] <- nobs(t2)
    growth[growth$AU==data,"baselineyr"] <- min(Data$Year)
    growth[growth$AU==data,"last.count"] <- Data[which(Data$Year==max(Data$Year)),"Total"]
    growth
   
# Figure
  yr1 <-data.frame(Year=min(Data[which(Data$Period=="2009-2014"),"Year"]):max(Data[which(Data$Period=="2009-2014"),"Year"]))
  pt1<-predict(t1,se=TRUE,type="response",newdata=yr1)
  (T1 <- data.frame(yr1,pt1))

  SHfig <- ggplot(Data) + 
    geom_line(data=T1,aes(Year,fit), lty="dotdash", lwd=1) +
    geom_ribbon(data=T1,aes(Year,ymax=fit+1.28*se.fit,ymin=fit-1.28*se.fit), fill="light blue", alpha=0.75) +
  geom_line(data=T2,aes(Year,fit), lty="dotted", lwd=1) +
    geom_ribbon(data=T2,aes(Year,ymax=fit+1.28*se.fit,ymin=fit-1.28*se.fit), fill="grey", alpha=0.5) +
    geom_point(data=Data, aes(x=Year, y=Total, col=Period)) + scale_x_continuous(limits=c(1992,2014),breaks=c(1995,2000,2005,2010)) + 
    scale_color_manual(values=c("1991-1996"="#e7298a","1997-2002"="#7570b3", "2003-2008"="#d95f02","2009-2014"="#1b9e77")) + 
    ylab("Grey seal moult count") + xlab("") +
    ggtitle(data) + 
    theme_bw() + theme(legend.position="none") 
  SHfig

## ----southeast england, results='hide', echo=FALSE, message=FALSE--------
# Southeast England
data <- "Southeast England"
Data <- pups_sum[which(pups_sum$Assessment_unit == data),]
ggplot(Data) + geom_point(aes(Year,Total,col=Period)) 

# Target 1: annual population growth rate in previous reporting round 
  t1 <- glm(Total~Year, data=subset(Data,Period=="2009-2014"),family=quasipoisson)
  summary(t1) 
  growth[growth$AU==data,"t1rate"] <- (summary(t1)$coef[2])*100
  growth[growth$AU==data,"t1U"] <- (summary(t1)$coef[2] + summary(t1)$coef[2,2])*100
  growth[growth$AU==data,"t1L"] <- (summary(t1)$coef[2] - summary(t1)$coef[2,2])*100
  growth[growth$AU==data,"t1N"] <- nobs(t1)
 
# Target 2: change in abundance since reference (1992 or earliest) year
    t2 <- gam(Total~s(Year),data=Data,family=quasipoisson) 
    
    # Fit(s)  
  yr<-data.frame(Year=min(Data$Year):max(Data$Year))
  pt2<-predict(t2,se=TRUE,type="response",newdata=yr)
  (T2<- data.frame(yr,pt2))
  # 80% confidence interval approximately 1.28 * s.e.
  (T2$upper80 <- T2$fit + 1.28*T2$se.fit) # upper 80% confidence limit
  (T2$lower80 <- T2$fit - 1.28*T2$se.fit) # lower 80% confidence limit
  
  # Calculate observed and mean fitted delta change
    growth[growth$AU==data,"t2deltaOBS"] <- with(Data,(((tail(Total,1)-head(Total,1))/head(Total,1)*100)))
    growth[growth$AU==data,"t2delta"] <- ((tail(T2$fit,1)-head(T2$fit,1))/head(T2$fit,1)*100)
    growth[growth$AU==data,"t2deltaU"] <- ((tail(T2$upper80,1)-head(T2$lower80,1))/head(T2$lower80,1)*100) 
  growth[growth$AU==data,"t2deltaL"] <- ((tail(T2$lower80,1)-head(T2$upper80,1))/head(T2$upper80,1)*100) 
    growth[growth$AU==data,"t2N"] <- nobs(t2)
    growth[growth$AU==data,"baselineyr"] <- min(Data$Year)
    growth[growth$AU==data,"last.count"] <- Data[which(Data$Year==max(Data$Year)),"Total"]
    growth
   
# Figure
  yr1 <-data.frame(Year=min(Data[which(Data$Period=="2009-2014"),"Year"]):max(Data[which(Data$Period=="2009-2014"),"Year"]))
  pt1<-predict(t1,se=TRUE,type="response",newdata=yr1)
  (T1 <- data.frame(yr1,pt1))

  SEfig <- ggplot(Data) + 
    geom_line(data=T1,aes(Year,fit), lty="dotdash", lwd=1) +
    geom_ribbon(data=T1,aes(Year,ymax=fit+1.28*se.fit,ymin=fit-1.28*se.fit), fill="light blue", alpha=0.75) +
  geom_line(data=T2,aes(Year,fit), lty="dotted", lwd=1) +
    geom_ribbon(data=T2,aes(Year,ymax=fit+1.28*se.fit,ymin=fit-1.28*se.fit), fill="grey", alpha=0.5) +
    geom_point(data=Data, aes(x=Year, y=Total, col=Period)) + scale_x_continuous(limits=c(1992,2014),breaks=c(1995,2000,2005,2010)) + 
    scale_color_manual(values=c("1991-1996"="#e7298a","1997-2002"="#7570b3", "2003-2008"="#d95f02","2009-2014"="#1b9e77")) + 
    ylab("Grey seal moult count") + xlab("") +
    ggtitle(data) + 
    theme_bw() + theme(legend.position="none") 
  SEfig

## ----wadden sea, results='hide', echo=FALSE, message=FALSE---------------
# Wadden Sea
data <- "Wadden Sea"
Data <- pups_sum[which(pups_sum$Assessment_unit == data),]
ggplot(Data) + geom_point(aes(Year,Total,col=Period)) 
    
# Target 1: annual population growth rate in previous reporting round 
  t1 <- glm(Total~Year, data=subset(Data,Period=="2009-2014"),family=quasipoisson)
  summary(t1) 
  growth[growth$AU==data,"t1rate"] <- (summary(t1)$coef[2])*100
  growth[growth$AU==data,"t1U"] <- confint(t1,parm="Year",level=0.8)[2]*100
  growth[growth$AU==data,"t1L"] <- confint(t1,parm="Year",level=0.8)[1]*100
  growth[growth$AU==data,"t1N"] <- nobs(t1)

# Target 2: change in abundance since reference (1992 or earliest) year
  # Model(s)  
  t2 <-  gam(Total~s(Year,k=4),data=Data,family=quasipoisson) 
     
  # Fit(s)  
  yr<-data.frame(Year=min(Data$Year):max(Data$Year))
  pt2<-predict(t2,se=TRUE,type="response",newdata=yr)
  (T2<- data.frame(yr,pt2))
  # 80% confidence interval approximately 1.28 * s.e.
  (T2$upper80 <- T2$fit + 1.28*T2$se.fit) # upper 80% confidence limit
  (T2$lower80 <- T2$fit - 1.28*T2$se.fit) # lower 80% confidence limit
  
  # Calculate observed and mean fitted delta change
    growth[growth$AU==data,"t2deltaOBS"] <- with(Data,(((tail(Total,1)-head(Total,1))/head(Total,1)*100)))
    growth[growth$AU==data,"t2delta"] <- ((tail(T2$fit,1)-head(T2$fit,1))/head(T2$fit,1)*100)
    growth[growth$AU==data,"t2deltaU"] <- ((tail(T2$upper80,1)-head(T2$lower80,1))/head(T2$lower80,1)*100) 
  growth[growth$AU==data,"t2deltaL"] <- ((tail(T2$lower80,1)-head(T2$upper80,1))/head(T2$upper80,1)*100) 
    growth[growth$AU==data,"t2N"] <- nobs(t2)
    growth[growth$AU==data,"baselineyr"] <- min(Data$Year)
    growth[growth$AU==data,"last.count"] <- Data[which(Data$Year==max(Data$Year)),"Total"]
    growth
   
# Figure
  yr1 <-data.frame(Year=min(Data[which(Data$Period=="2009-2014"),"Year"]):max(Data[which(Data$Period=="2009-2014"),"Year"]))
  pt1<-predict(t1,se=TRUE,type="response",newdata=yr1)
  (T1 <- data.frame(yr1,pt1))

  WAfig <- ggplot(Data) + 
    geom_line(data=T1,aes(Year,fit), lty="dotdash", lwd=1) +
    geom_ribbon(data=T1,aes(Year,ymax=fit+1.28*se.fit,ymin=fit-1.28*se.fit), fill="light blue", alpha=0.75) +
  geom_line(data=T2,aes(Year,fit), lty="dotted", lwd=1) +
    geom_ribbon(data=T2,aes(Year,ymax=fit+1.28*se.fit,ymin=fit-1.28*se.fit), fill="grey", alpha=0.5) +
    geom_point(data=Data, aes(x=Year, y=Total, col=Period)) + scale_x_continuous(limits=c(1992,2014),breaks=c(1995,2000,2005,2010)) + 
    scale_color_manual(values=c("1991-1996"="#e7298a","1997-2002"="#7570b3", "2003-2008"="#d95f02","2009-2014"="#1b9e77")) + 
    ylab("Grey seal moult count") + xlab("") +
    ggtitle(data) + 
    theme_bw() + theme(legend.position="none") 
  WAfig

## ----wadden sea - NL, results='hide', echo=FALSE, message=FALSE----------
# Wadden Sea
data <- "Wadden Sea - NL"
Data <- pups_sum[which(pups_sum$Assessment_unit == data),]
ggplot(Data) + geom_point(aes(Year,Total,col=Period)) 
    
# Target 1: annual population growth rate in previous reporting round 
  t1 <- glm(Total~Year, data=subset(Data,Period=="2009-2014"),family=quasipoisson)
  summary(t1) 
  growth[growth$AU==data,"t1rate"] <- (summary(t1)$coef[2])*100
  growth[growth$AU==data,"t1U"] <- confint(t1,parm="Year",level=0.8)[2]*100
  growth[growth$AU==data,"t1L"] <- confint(t1,parm="Year",level=0.8)[1]*100
  growth[growth$AU==data,"t1N"] <- nobs(t1)

# Target 2: change in abundance since reference (1992 or earliest) year
  # Model(s)  
  t2 <-  gam(Total~s(Year,k=4),data=Data,family=quasipoisson) 
     
  # Fit(s)  
  yr<-data.frame(Year=min(Data$Year):max(Data$Year))
  pt2<-predict(t2,se=TRUE,type="response",newdata=yr)
  (T2<- data.frame(yr,pt2))
  # 80% confidence interval approximately 1.28 * s.e.
  (T2$upper80 <- T2$fit + 1.28*T2$se.fit) # upper 80% confidence limit
  (T2$lower80 <- T2$fit - 1.28*T2$se.fit) # lower 80% confidence limit
  
  # Calculate observed and mean fitted delta change
    growth[growth$AU==data,"t2deltaOBS"] <- with(Data,(((tail(Total,1)-head(Total,1))/head(Total,1)*100)))
    growth[growth$AU==data,"t2delta"] <- ((tail(T2$fit,1)-head(T2$fit,1))/head(T2$fit,1)*100)
    growth[growth$AU==data,"t2deltaU"] <- ((tail(T2$upper80,1)-head(T2$lower80,1))/head(T2$lower80,1)*100) 
  growth[growth$AU==data,"t2deltaL"] <- ((tail(T2$lower80,1)-head(T2$upper80,1))/head(T2$upper80,1)*100) 
    growth[growth$AU==data,"t2N"] <- nobs(t2)
    growth[growth$AU==data,"baselineyr"] <- min(Data$Year)
    growth[growth$AU==data,"last.count"] <- Data[which(Data$Year==max(Data$Year)),"Total"]
    growth
   
# Figure
  yr1 <-data.frame(Year=min(Data[which(Data$Period=="2009-2014"),"Year"]):max(Data[which(Data$Period=="2009-2014"),"Year"]))
  pt1<-predict(t1,se=TRUE,type="response",newdata=yr1)
  (T1 <- data.frame(yr1,pt1))

  WANLfig <- ggplot(Data) + 
    geom_line(data=T1,aes(Year,fit), lty="dotdash", lwd=1) +
    geom_ribbon(data=T1,aes(Year,ymax=fit+1.28*se.fit,ymin=fit-1.28*se.fit), fill="light blue", alpha=0.75) +
  geom_line(data=T2,aes(Year,fit), lty="dotted", lwd=1) +
    geom_ribbon(data=T2,aes(Year,ymax=fit+1.28*se.fit,ymin=fit-1.28*se.fit), fill="grey", alpha=0.5) +
    geom_point(data=Data, aes(x=Year, y=Total, col=Period)) + scale_x_continuous(limits=c(1992,2014),breaks=c(1995,2000,2005,2010)) + 
    scale_color_manual(values=c("1991-1996"="#e7298a","1997-2002"="#7570b3", "2003-2008"="#d95f02","2009-2014"="#1b9e77")) + 
    ylab("Grey seal moult count") + xlab("") +
    ggtitle(data) + 
    theme_bw() + theme(legend.position="none") 
  WANLfig

## ----wales, results='hide', echo=FALSE, message=FALSE--------------------
# Wales
data <- "Wales"
Data <- pups_sum[which(pups_sum$Assessment_unit == data),]
ggplot(Data) + geom_point(aes(Year,Total,col=Period)) 
    
# Target 1: annual population growth rate in previous reporting round 
  # only one count in last period that we have - there are more pup data from T. Stringell but not yet in format that I could use (needs cleaning)
  growth[growth$AU==data,"t1N"] <- length(which(Data$Period=="2009-2014"))
     
# Target 2: change in abundance since reference (1992 or earliest) year
  # Model(s)  
  t2 <- glm(Total ~ Year, data=Data, family=quasipoisson)
  summary(t2)
  
  # Fit(s)  
  yr<-data.frame(Year=min(Data$Year):max(Data$Year))
  pt2<-predict(t2,se=TRUE,type="response",newdata=yr)
  (T2<- data.frame(yr,pt2))
  # 80% confidence interval approximately 1.28 * s.e.
  (T2$upper80 <- T2$fit + 1.28*T2$se.fit) # upper 80% confidence limit
  (T2$lower80 <- T2$fit - 1.28*T2$se.fit) # lower 80% confidence limit
  
  # Calculate observed and mean fitted delta change
    growth[growth$AU==data,"t2deltaOBS"] <- with(Data,(((tail(Total,1)-head(Total,1))/head(Total,1)*100)))
    growth[growth$AU==data,"t2delta"] <- ((tail(T2$fit,1)-head(T2$fit,1))/head(T2$fit,1)*100)
    growth[growth$AU==data,"t2deltaU"] <- ((tail(T2$upper80,1)-head(T2$lower80,1))/head(T2$lower80,1)*100) 
  growth[growth$AU==data,"t2deltaL"] <- ((tail(T2$lower80,1)-head(T2$upper80,1))/head(T2$upper80,1)*100) 
    growth[growth$AU==data,"t2N"] <- nobs(t2)
    growth[growth$AU==data,"baselineyr"] <- min(Data$Year)
    growth[growth$AU==data,"last.count"] <- Data[which(Data$Year==max(Data$Year)),"Total"]
    growth
   
# Figure

  WLfig <- ggplot(Data) + 
    #geom_line(data=T1,aes(Year,fit), lty="dotdash", lwd=1) +
    #geom_ribbon(data=T1,aes(Year,ymax=fit+1.28*se.fit,ymin=fit-1.28*se.fit), fill="light blue", alpha=0.75) +
  geom_line(data=T2,aes(Year,fit), lty="dotted", lwd=1) +
    geom_ribbon(data=T2,aes(Year,ymax=fit+1.28*se.fit,ymin=fit-1.28*se.fit), fill="grey", alpha=0.5) +
    geom_point(data=Data, aes(x=Year, y=Total, col=Period)) + scale_x_continuous(limits=c(1992,2014),breaks=c(1995,2000,2005,2010)) + 
    scale_color_manual(values=c("1991-1996"="#e7298a","1997-2002"="#7570b3", "2003-2008"="#d95f02","2009-2014"="#1b9e77")) + 
    ylab("Grey seal moult count") + xlab("") +
    ggtitle(data) + 
    theme_bw() + theme(legend.position="none") 
  WLfig

## ----west scotland, results='hide', echo=FALSE, message=FALSE------------
# West Scotland
data <- "West Scotland"
Data <- pups_sum[which(pups_sum$Assessment_unit == data),]
ggplot(Data) + geom_point(aes(Year,Total,col=Period)) 
    
# Target 1: annual population growth rate in previous reporting round 
  t1 <- glm(Total~Year, data=subset(Data,Period=="2009-2014"),family=quasipoisson)
  summary(t1) 
  growth[growth$AU==data,"t1rate"] <- (summary(t1)$coef[2])*100
  growth[growth$AU==data,"t1U"] <- confint(t1,parm="Year",level=0.8)[2]*100
  growth[growth$AU==data,"t1L"] <- confint(t1,parm="Year",level=0.8)[1]*100
  growth[growth$AU==data,"t1N"] <- nobs(t1)

# Target 2: change in abundance since reference (1992 or earliest) year
  # Model(s)  
  t2<- gam(Total~s(Year,k=4),data=Data,family=quasipoisson) # exponential increase
  
  # Fit(s)  
  yr<-data.frame(Year=min(Data$Year):max(Data$Year))
  pt2<-predict(t2,se=TRUE,type="response",newdata=yr)
  (T2<- data.frame(yr,pt2))
  # 80% confidence interval approximately 1.28 * s.e.
  (T2$upper80 <- T2$fit + 1.28*T2$se.fit) # upper 80% confidence limit
  (T2$lower80 <- T2$fit - 1.28*T2$se.fit) # lower 80% confidence limit
  
  # Calculate observed and mean fitted delta change
    growth[growth$AU==data,"t2deltaOBS"] <- with(Data,(((tail(Total,1)-head(Total,1))/head(Total,1)*100)))
    growth[growth$AU==data,"t2delta"] <- ((tail(T2$fit,1)-head(T2$fit,1))/head(T2$fit,1)*100)
    growth[growth$AU==data,"t2deltaU"] <- ((tail(T2$upper80,1)-head(T2$lower80,1))/head(T2$lower80,1)*100) 
  growth[growth$AU==data,"t2deltaL"] <- ((tail(T2$lower80,1)-head(T2$upper80,1))/head(T2$upper80,1)*100) 
    growth[growth$AU==data,"t2N"] <- nobs(t2)
    growth[growth$AU==data,"baselineyr"] <- min(Data$Year)
    growth[growth$AU==data,"last.count"] <- Data[which(Data$Year==max(Data$Year)),"Total"]
    growth
   
# Figure
  yr1 <-data.frame(Year=min(Data[which(Data$Period=="2009-2014"),"Year"]):max(Data[which(Data$Period=="2009-2014"),"Year"]))
  pt1<-predict(t1,se=TRUE,type="response",newdata=yr1)
  (T1 <- data.frame(yr1,pt1))

  WSfig <- ggplot(Data) + 
    geom_line(data=T1,aes(Year,fit), lty="dotdash", lwd=1) +
    geom_ribbon(data=T1,aes(Year,ymax=fit+1.28*se.fit,ymin=fit-1.28*se.fit), fill="light blue", alpha=0.75) +
    geom_line(data=T2,aes(Year,fit), lty="dotted", lwd=1) +
    geom_ribbon(data=T2,aes(Year,ymax=fit+1.28*se.fit,ymin=fit-1.28*se.fit), fill="grey", alpha=0.5) +
    geom_point(data=Data, aes(x=Year, y=Total, col=Period)) + scale_x_continuous(limits=c(1992,2014),breaks=c(1995,2000,2005,2010)) + 
    scale_color_manual(values=c("1991-1996"="#e7298a","1997-2002"="#7570b3", "2003-2008"="#d95f02","2009-2014"="#1b9e77")) + 
    ylab("Grey seal moult count") + xlab("") +
    ggtitle(data) + 
    theme_bw() + theme(legend.position="none")  
  WSfig

## ----western isles, results='hide', echo=FALSE, message=FALSE------------
# Western Isles
data <- "Western Isles"
Data <- pups_sum[which(pups_sum$Assessment_unit == data),]
ggplot(Data) + geom_point(aes(Year,Total,col=Period)) 
    
# Target 1: annual population growth rate in previous reporting round 
  t1 <- glm(Total~Year, data=subset(Data,Period=="2009-2014"),family=quasipoisson)
  summary(t1) 
  growth[growth$AU==data,"t1rate"] <- (summary(t1)$coef[2])*100
  growth[growth$AU==data,"t1U"] <- confint(t1,parm="Year",level=0.8)[2]*100
  growth[growth$AU==data,"t1L"] <- confint(t1,parm="Year",level=0.8)[1]*100
  growth[growth$AU==data,"t1N"] <- nobs(t1)

# Target 2: change in abundance since reference (1992 or earliest) year
  # Model(s)  
  t2<- gam(Total~s(Year,k=4),data=Data,family=quasipoisson) 
  
  # Fit(s)  
  yr<-data.frame(Year=min(Data$Year):max(Data$Year))
  pt2<-predict(t2,se=TRUE,type="response",newdata=yr)
  (T2<- data.frame(yr,pt2))
  # 80% confidence interval approximately 1.28 * s.e.
  (T2$upper80 <- T2$fit + 1.28*T2$se.fit) # upper 80% confidence limit
  (T2$lower80 <- T2$fit - 1.28*T2$se.fit) # lower 80% confidence limit
  
  # Calculate observed and mean fitted delta change
    growth[growth$AU==data,"t2deltaOBS"] <- with(Data,(((tail(Total,1)-head(Total,1))/head(Total,1)*100)))
    growth[growth$AU==data,"t2delta"] <- ((tail(T2$fit,1)-head(T2$fit,1))/head(T2$fit,1)*100)
    growth[growth$AU==data,"t2deltaU"] <- ((tail(T2$upper80,1)-head(T2$lower80,1))/head(T2$lower80,1)*100) 
  growth[growth$AU==data,"t2deltaL"] <- ((tail(T2$lower80,1)-head(T2$upper80,1))/head(T2$upper80,1)*100) 
    growth[growth$AU==data,"t2N"] <- nobs(t2)
    growth[growth$AU==data,"baselineyr"] <- min(Data$Year)
    growth[growth$AU==data,"last.count"] <- Data[which(Data$Year==max(Data$Year)),"Total"]
    growth
   
# Figure
  yr1 <-data.frame(Year=min(Data[which(Data$Period=="2009-2014"),"Year"]):max(Data[which(Data$Period=="2009-2014"),"Year"]))
  pt1<-predict(t1,se=TRUE,type="response",newdata=yr1)
  (T1 <- data.frame(yr1,pt1))

  WIfig <- ggplot(Data) + 
    geom_line(data=T1,aes(Year,fit), lty="dotdash", lwd=1) +
    geom_ribbon(data=T1,aes(Year,ymax=fit+1.28*se.fit,ymin=fit-1.28*se.fit), fill="light blue", alpha=0.75) +
    geom_line(data=T2,aes(Year,fit), lty="dotted", lwd=1) +
    geom_ribbon(data=T2,aes(Year,ymax=fit+1.28*se.fit,ymin=fit-1.28*se.fit), fill="grey", alpha=0.5) +
    geom_point(data=Data, aes(x=Year, y=Total, col=Period)) + scale_x_continuous(limits=c(1992,2014),breaks=c(1995,2000,2005,2010)) + 
    scale_color_manual(values=c("1991-1996"="#e7298a","1997-2002"="#7570b3", "2003-2008"="#d95f02","2009-2014"="#1b9e77")) + 
    ylab("Grey seal moult count") + xlab("") +
    ggtitle(data) + 
    theme_bw() + theme(legend.position="none")  
  WIfig

## ----plot export, results='hide', echo=FALSE, message=FALSE--------------
pdf("Figure_B_Hgpups_models.pdf")
ESfig;MFfig;OKfig;NEfig;SNfig;SHfig;SEfig;WAfig;WANLfig;WLfig;WSfig;WIfig
dev.off()

## ----occupancy, results='hide', echo=FALSE-------------------------------

head(coldistrib)
   # German data included here from 3 regions monitored by TSEG, but these data only start in 2007 (last reporting round) so in order to compare with the previous reporting round, we can only use data submitted by NL and DK
  #coldistrib <- coldistrib[which(coldistrib$Country!="DE"),]
   
  
  # for each site/subarea, split into reporting periods and calculate the number of time the site/colony was surveyed, and then how many times it was found occupied within those times it was surveyed
    # NB: In the UK, we have no colonies with 0 counts because, by definition, the surveys cover established colonies. A new colony will be added once identified by the whole coastline or subarea is not 'searched' for breeding seals necessarily as may be the case in some other AUs
    # It therefore does not make sense to use the proportion of occupied colonies/sites as an indicator because this will always be 1 in the UK. Use instead the number of occupied colonies (nocc)
  
  head(coldistrib)
  
  # split by Assessment Unit, colony/site and reporting period, calculate the number of years each colony/site was surveyed and how many times found occupied. We assume that years not included in the database = not survyed.
  head(temp <- ddply(coldistrib,c("Assessment_unit","Site_name_ID","Period"),summarise,nsurv=length(unique(Year)),nocc=length(which(Presence==1))))
  
  # now split this df by AU and reporting period and calculate the number of unique sites that were surveyed and the number of sites found occupied, and proportion of occupied areas in each period
  (coldistrib_sum <- ddply(temp, c("Assessment_unit","Period"), summarise,nsites=length(which(nsurv>0)), nocc=length(which(nocc>0)),propocc=nocc/nsites))
  
  # subset to last two reporting rounds of interest
  (colocc <- coldistrib_sum[coldistrib_sum$Period %in% c("2003-2008","2009-2014"),])

  # calculate change in occupany rate between periods in each AU
  (rolling <- ddply(colocc,"Assessment_unit",summarise,occupancy=diff(propocc),survdiff=diff(nsites)))
  rolling <- rename(rolling,c("Assessment_unit"="AU"))
  
growth <- merge(growth,rolling,by="AU",all.x=TRUE)
growth

## ----shift, results='hide', echo=FALSE-----------------------------------
# shift calculation does not make sense for grey seal colony data we have which focuses on areas where we know there are animals.

## ----write tables, results='hide', echo=FALSE, message=FALSE-------------
str(growth); 
growth

writeDataTable(wb = MSFD_tables, sheet = 3, x = growth)
saveWorkbook(MSFD_tables,"MSFD_tables.xlsx",overwrite = TRUE)

# write a normal (non Markdown) R file:
library(knitr)
getwd()
file.exists("Rfile_A_M5_play.Rmd")
purl("Rfile_A_M5_play.Rmd")

