REMARK 'file OSPARtableQueries.sql'

cOLUMN SpeciesName	FORMAT A25
COLUMN AreaDescription FORMAT A100;
COLUMN EcoQORegion	FORMAT A25
COLUMN OSPAR2agg      FORMAT A25;
COLUMN WADQSR          FORMAT A55;


REMARK '---------- QUERY TO CHECK FOR START YEAR OF REGIONAL DATA --------

SELECT
max(YEAR) 		YEAR,
MAX(EcoQORegion)	EcoQORegion,
COUNT(SampleCode)	n
FROM OSPARTable
WHERE SpeciesName='Fulmarus glacialis'
      AND AGEGR!='PULLI'
      GROUP BY YEAR, EcoQORegion
      ORDER BY YEAR, EcoQOReGION
;


REMARK '-----------------GENERAL DATA QUERY FOR REGIONAL ANALYSES --------------------'

SELECT 
MAX(SpeciesName)	SpeciesName,
MAX(EcoQORegion)	EcoQORegion,
MAX(PENTADE1)		PENTADE1,
COUNT(SampleCode)	n,
SUM(DECODE(AGEGR,'ADULT',1,0)) / (SUM(DECODE(AGEGR,'ADULT',1,0)) + SUM(DECODE(AGEGR,'NONAD',1,0))+0.0001) P_Ad,
SUM(DECODE(SEX,'M',1,0)) / (SUM(DECODE(SEX,'M',1,0)) + SUM(DECODE(SEX,'F',1,0))+0.0001) P_M,
((SUM(DECODE(NPLA,0,0,1)))/(COUNT(NPLA)))      PPLA, 
AVG(NPLA)                                                                         avgNPLA,
(SQRT(VARIANCE(NPLA)))/SQRT(COUNT(NPLA))  seNPLA,
MAX(NPLA)                                                                       maxNPLA, 
EXP(AVG(lnNPLA))-0.001                                                 geoNPLA,
AVG(GPLA)                                                                         avgGPLA,
(SQRT(VARIANCE(GPLA)))/SQRT(COUNT(NPLA))  seGPLA,
MAX(GPLA)                                                                       maxGPLA, 
EXP(AVG(lnGPLA))-0.001                                                  geoGPLA,
    SUM(EcoQ_n10)/COUNT(Ecoq_n10)   		  OVERn10,
     SUM(EcoQ_g01)/COUNT(Ecoq_g01)  		  OVERg01,
((SUM(DECODE(NIND,0,0,1)))/(COUNT(NPLA)))  PIND, 
AVG(NIND)               avgNIND,
(SQRT(VARIANCE(NIND)))/SQRT(COUNT(NPLA))  seNIND,
MAX(NIND)               maxNIND, 
EXP(AVG(lnNIND))-0.001  geoNIND,
AVG(GIND)               avgGIND,
(SQRT(VARIANCE(GIND)))/SQRT(COUNT(NPLA))  seGIND,
MAX(GIND)               maxGIND, 
EXP(AVG(lnGIND))-0.001  geoGIND,
   ((SUM(DECODE(NUSE,0,0,1)))/(COUNT(NPLA)))  PUSE, 
AVG(NUSE)               avgNUSE,
(SQRT(VARIANCE(NUSE)))/SQRT(COUNT(NPLA))  seNUSE,
MAX(NUSE)               maxNUSE, 
EXP(AVG(lnNUSE))-0.001  geoNUSE,
AVG(GUSE)               avgGUSE,
(SQRT(VARIANCE(Guse)))/SQRT(COUNT(NPLA))  seGUSE,
MAX(GUSE)               maxGUSE, 
EXP(AVG(lnGUSE))-0.001  geoGUSE
FROM OSPARTable
WHERE SpeciesName='Fulmarus glacialis'
      AND AGEGR!='PULLI'
      AND AGEGR='NONAD'
     AND PENTADE1 IS NOT NULL
      GROUP BY EcoQORegion, PENTADE1
      ORDER BY EcoQORegion, PENTADE1
 ;

NAAR LEEFTIJDSGROEP EVT TOE TE VOEGEN WHERE CLAUSE:
      AND AGEGR='ADULT'
OF
       AND AGEGR='NONAD'


remark '==================IDEM for North Sea Totals================'
SELECT 
MAX(SpeciesName)	SpeciesName,
MAX(EcoQORegion)	EcoQORegion,
MAX(PENTADE1)		PENTADE1,
COUNT(SampleCode)	n,
SUM(DECODE(AGEGR,'ADULT',1,0)) / (SUM(DECODE(AGEGR,'ADULT',1,0)) + SUM(DECODE(AGEGR,'NONAD',1,0))+0.0001) P_Ad,
SUM(DECODE(SEX,'M',1,0)) / (SUM(DECODE(SEX,'M',1,0)) + SUM(DECODE(SEX,'F',1,0))+0.0001) P_M,
((SUM(DECODE(NPLA,0,0,1)))/(COUNT(NPLA)))      PPLA, 
AVG(NPLA)                                                                         avgNPLA,
(SQRT(VARIANCE(NPLA)))/SQRT(COUNT(NPLA))  seNPLA,
MAX(NPLA)                                                                       maxNPLA, 
EXP(AVG(lnNPLA))-0.001                                                 geoNPLA,
AVG(GPLA)                                                                         avgGPLA,
(SQRT(VARIANCE(GPLA)))/SQRT(COUNT(NPLA))  seGPLA,
MAX(GPLA)                                                                       maxGPLA, 
EXP(AVG(lnGPLA))-0.001                                                  geoGPLA,
    SUM(EcoQ_n10)/COUNT(Ecoq_n10)   		  OVERn10,
     SUM(EcoQ_g01)/COUNT(Ecoq_g01)  		  OVERg01,
((SUM(DECODE(NIND,0,0,1)))/(COUNT(NPLA)))  PIND, 
AVG(NIND)               avgNIND,
(SQRT(VARIANCE(NIND)))/SQRT(COUNT(NPLA))  seNIND,
MAX(NIND)               maxNIND, 
EXP(AVG(lnNIND))-0.001  geoNIND,
AVG(GIND)               avgGIND,
(SQRT(VARIANCE(GIND)))/SQRT(COUNT(NPLA))  seGIND,
MAX(GIND)               maxGIND, 
EXP(AVG(lnGIND))-0.001  geoGIND,
   ((SUM(DECODE(NUSE,0,0,1)))/(COUNT(NPLA)))  PUSE, 
AVG(NUSE)               avgNUSE,
(SQRT(VARIANCE(NUSE)))/SQRT(COUNT(NPLA))  seNUSE,
MAX(NUSE)               maxNUSE, 
EXP(AVG(lnNUSE))-0.001  geoNUSE,
AVG(GUSE)               avgGUSE,
(SQRT(VARIANCE(Guse)))/SQRT(COUNT(NPLA))  seGUSE,
MAX(GUSE)               maxGUSE, 
EXP(AVG(lnGUSE))-0.001  geoGUSE
FROM OSPARTable
WHERE SpeciesName='Fulmarus glacialis'
      AND AGEGR!='PULLI'
     AND PENTADE1 IS NOT NULL
      GROUP BY PENTADE1
      ORDER BY PENTADE1
 ;

NAAR LEEFTIJDSGROEP EVT TOE TE VOEGEN WHERE CLAUSE:
      AND AGEGR='ADULT'
 OF      AND AGEGR='NONAD'


REMARK '------------------ GENSTAT LISTING QUERY -------------'

set NULL xxx;
column lnNPLA format 9999.99999
column lnGPLA format 9999.99999
column lnNIND format 9999.99999
column lnGIND format 9999.99999
column lnNUSE format 9999.99999
column lnGUSE format 9999.99999


SELECT 
SAMPLECODE,
EcoQORegion,
OSPAR2AGG,
WADQSR,
YEAR,
AGEGR,
NPLA,
GPLA,
NIND,
GIND,
NUSE,
GUSE,
lnNPLA,
lnGPLA,
lnNIND,
lnGIND,
lnNUSE,
lnGUSE,
EcoQ_g01,   
DECODE(NPLA,0,0,1)      INC 
FROM OSPARTable
WHERE SpeciesName='Fulmarus glacialis'
ORDER BY ECOQOREGION, SAMPLECODE;



