REMARK '===filename OSPAREview.sql
REMARK '===creating additions and adustments to table OSPARECOQO renaming it to OSPARview'
REMARK '===================================================================='

REMARK '==== view OSPAR_DATE is tussenstap om datumtijd 
REMARK '==== naar datumformaat 'DATETIME' te schrijven'
REMARK '===================================================================='

DROP VIEW OSPAR_DATE ;
          COLUMN DATE FORMAT 99999999

REMARK 'Do not use DATE - not allowed, use eg JAFDATUM'

CREATE VIEW OSPAR_DATE
AS SELECT N.*,
TO_DATE(N.SampleDate,'YYYYMMDD') JAFDATUM
FROM OSPARECOQO N
;

REMARK '====== final table maakt direct opvraagbare datum en tijd vormen beschikbaar========'

DROP TABLE OSPARview
;
CREATE TABLE OSPARview 
AS SELECT N.*,
  TO_CHAR(N.JAFDATUM, 'YYYY') YEAR,
  TO_CHAR(N.JAFDATUM, 'MM') MONTH,
  TO_CHAR(N.JAFDATUM, 'WW') WEEKNR,
  TO_CHAR(N.JAFDATUM, 'DD') DAYNR,
  TO_CHAR(N.JAFDATUM, 'J') JULDATE
FROM OSPAR_DATE N
;

REMARK '======================================================================'
REMARK '=======ADDING COLUMN(S) FOR FIVE YEAR PERIODS PENTADE(S)==========='
REMARK '----------------------------------------------------------------------------------------------------------------'

     ALTER TABLE OSPARview    DROP COLUMN PENTADE1;
     ALTER TABLE OSPARview   ADD (PENTADE1 VARCHAR2(10));
UPDATE OSPARview
  SET PENTADE1='2000_04'
  WHERE (YEAR>=2000 AND YEAR<=2004);
UPDATE OSPARview
  SET PENTADE1='2005_09'
  WHERE (YEAR>=2005 AND YEAR<=2009);
UPDATE OSPARview
  SET PENTADE1='2010_14'
  WHERE (YEAR>=2010 AND YEAR<=2014);
UPDATE OSPARview
  SET PENTADE1='2015_19'
  WHERE (YEAR>=2015 AND YEAR<=2019);

COLUMN PENTADE1 FORMAT A10;
------------

   ALTER TABLE OSPARview    DROP COLUMN PENTADE2;
   ALTER TABLE OSPARview   ADD (PENTADE2 VARCHAR2(10));
UPDATE OSPARview
  SET PENTADE2='2001_05'
  WHERE (YEAR>=2001 AND YEAR<=2005);
UPDATE OSPARview
  SET PENTADE2='2006_10'
  WHERE (YEAR>=2006 AND YEAR<=2010);
UPDATE OSPARview
  SET PENTADE2='2011_15'
  WHERE (YEAR>=2011 AND YEAR<=2015);
UPDATE OSPARview
  SET PENTADE2='2016_20'
  WHERE (YEAR>=2016 AND YEAR<=2020);

COLUMN PENTADE2 FORMAT A10;
-------------

ALTER TABLE OSPARview    DROP COLUMN PENTADE3;
ALTER TABLE OSPARview  ADD (PENTADE3 VARCHAR2(10));
UPDATE OSPARview
  SET PENTADE3='2002_06'
  WHERE (YEAR>=2002 AND YEAR<=2006);
UPDATE OSPARview
  SET PENTADE3='2007_11'
  WHERE (YEAR>=2007 AND YEAR<=2011);
UPDATE OSPARview
  SET PENTADE3='2012_16'
  WHERE (YEAR>=2012 AND YEAR<=2016);
UPDATE OSPARview
  SET PENTADE3='2017_21'
  WHERE (YEAR>=2017 AND YEAR<=2021);

COLUMN PENTADE3 FORMAT A10;
--------------

ALTER TABLE OSPARview    DROP COLUMN PENTADE4;
ALTER TABLE OSPARview  ADD (PENTADE4 VARCHAR2(10));
UPDATE OSPARview
  SET PENTADE4='2003_07'
  WHERE (YEAR>=2003 AND YEAR<=2007);
UPDATE OSPARview
  SET PENTADE4='2008_12'
  WHERE (YEAR>=2008 AND YEAR<=2012);
UPDATE OSPARview
  SET PENTADE4='2013_17'
  WHERE (YEAR>=2013 AND YEAR<=2017);
UPDATE OSPARview
  SET PENTADE4='2018_22'
  WHERE (YEAR>=2018 AND YEAR<=2022);

COLUMN PENTADE4 FORMAT A10;
--------------

ALTER TABLE OSPARview    DROP COLUMN PENTADE5;
ALTER TABLE OSPARview  ADD (PENTADE5 VARCHAR2(10));
UPDATE OSPARview
  SET PENTADE5='2004_08'
  WHERE (YEAR>=2004 AND YEAR<=2008);
UPDATE OSPARview
  SET PENTADE5='2009_13'
  WHERE (YEAR>=2009 AND YEAR<=2013);
UPDATE OSPARview
  SET PENTADE5='2014_18'
  WHERE (YEAR>=2014 AND YEAR<=2018);
UPDATE OSPARview
  SET PENTADE5='2019_23'
  WHERE (YEAR>=2019 AND YEAR<=2023);

COLUMN PENTADE5 FORMAT A10;


REMARK '======================================================================'
REMARK '====CREATING TABLE OSPARtable with regional grouping identifiers and area description='
REMARK '----------------------------------------------------------------------------------------------------------------'

DROP TABLE OSPARtable;
COMMIT;

CREATE TABLE OSPARtable
AS SELECT N.*, A.AreaDescription,A.EcoQORegion, A.OSPAR2agg, A.WADQSR,
	LN(N.NIND+1)     lnNIND, 
	LN(N.NUSE+1)     lnNUSE,
	LN(N.NPLA+1)     lnNPLA, 
	LN(N.GIND+0.001)     lnGIND, 
	LN(N.GUSE+0.001)     lnGUSE,
	LN(N.GPLA+0.001)     lnGPLA 
    FROM OSPARview N, AreaCodeTable A
    WHERE N.AreaCode=A.AreaCode
;
COMMIT;

COLUMN AreaDescription FORMAT A100;
COLUMN EcoQORegion	FORMAT A25
COLUMN OSPAR2agg      FORMAT A25;
COLUMN WADQSR          FORMAT A55;

REMARK '====ADDING COLUMNS FOR ECOQO CALCULATIONS (NUMBER>10 OR GRAM>0.1)============'
REMARK 'percentage above nr or mass criterion may be queried by eg SUM(EcoQ_n10) / COUNT(EcoQO_n10)======'

ALTER TABLE OSPARtable
  ADD (EcoQ_n10 NUMBER(2));
UPDATE OSPARtable
 SET EcoQ_n10=1
 WHERE NPLA>=10;
UPDATE OSPARtable
 SET EcoQ_n10=0
 WHERE NPLA<10;

ALTER TABLE OSPARtable
  ADD (EcoQ_g01 NUMBER(2));
UPDATE OSPARtable
 SET EcoQ_g01=1
 WHERE GPLA>=0.1;
UPDATE OSPARtable
 SET EcoQ_g01=0
 WHERE GPLA<0.1;

