#
# SPANISH ANALYSIS MIGHT HAVE BUGGERED CODE A BIT. THINK I'VE COMMENTED OUT
# SPANISH STUFF NOW.
#
# Stuff to do
# Need to sort the plots out. Might have to use the image function and then add the legend manually. The problem seems to come with resetting the plotting region after use of image.plot. Just tried reset.graphics=T and it sorts out the points but not the plot region.
# Check the GAM smoothing modelling.
# Could formally compare regions / years if one wants to.
#
# THERE ARE TWO SITUATIONS IN WHICH RECO-LT YIELDS A "1" RATHER THAN A "0".
# I'VE PUT THESE AS 0 FOR NOW.

# Cigarette butts and buds have been coded as 'other plastic'

# 9 NA rows with 0 for items and for other important stuff removed from data
# file.
#

setwd('C:\\Documents and Settings\\jtb00\\My Documents\\Fish Stuff\\Consultancy 2016\\Litter - Thomas Maes')
####
#### I deleted 9 rows in the data file that had NULL for litter items
#### and all of the columns before it
####
#### Theres is no code for A14 or for B8
####
library(fields)

d = read.csv(file='litter.csv', header=T, stringsAsFactors=F)

region = d$Region
country2 = d$Country
gear2 = d$Gear
survey = d$Survey
stat = d$StNo
haul = d$HaulNo
ltref2 = d$LTREF
param2 = d$PARAM
items2 = d$LT_Items
day = d$Day
month = d$month
year = d$Year
daynight2 = d$DayNight
lat = d$HaulLat
long = d$HaulLong
dist = d$Distance
door = d$DoorSpread
wing = d$WingSpread

table(region)
region[region==""] = "Celtic"
table(region)

param = trimws(param2)                    # Remove white space blanks
table(param)
length(param)                             # 8910 observations
country = trimws(country2)
daynight = trimws(daynight2)
gear = trimws(gear2)
ltref = trimws(ltref2)

items = items2
table(items2)                       # 177 -9 values
table(items2, country)              # 12 France, 1 Scotland, 164 Sweden
items[items2==-9] = 0               # Check that this is correct thing to do
table(items)

table(year)                         # Use only 2012 to 2014
iny = (year >=2012) & (year<=2014)
sum(iny)

region = region[iny]
country = country[iny]
gear = gear[iny]
survey = survey[iny]
stat = stat[iny]
haul = haul[iny]
ltref = ltref[iny]
param = param[iny]
items = items[iny]
day = day[iny]
month = month[iny]
year = year[iny]
daynight = daynight[iny]
lat = lat[iny]
long = long[iny]
dist = dist[iny]
door = door[iny]
wing = wing[iny]

table(year)

table(gear, region)                    # Biscay uses BAK (1441) and GOV (646)

#gov = gear=="GOV"
gov = gear=="BAK"                      # For Spanish analysis only

region3 = region[gov]
country3 = country[gov]
gear3 = gear[gov]
survey3 = survey[gov]
stat3 = stat[gov]
haul3 = haul[gov]
ltref3 = ltref[gov]
param3 = param[gov]
items3 = items[gov]
day3 = day[gov]
month3 = month[gov]
year3 = year[gov]
daynight3 = daynight[gov]
lat3 = lat[gov]
long3 = long[gov]
dist3 = dist[gov]
door3 = door[gov]
wing3 = wing[gov]

nobs = length(items3)     # 4548

####
#### Convert the data file to one where there is one row per haul and the
#### litter amounts are summed over the rows of the current file for that haul.
####

region4 = rep(0,nobs)
country4 = rep(0,nobs)
gear4 = rep(0,nobs)
survey4 = rep(0,nobs)
stat4 = rep(0,nobs)
haul4 = rep(0,nobs)
ltref4 = rep(0,nobs)
param4 = rep(0,nobs)
items4 = rep(0,nobs)
day4 = rep(0,nobs)
month4 = rep(0,nobs)
year4 = rep(0,nobs)
daynight4 = rep(0,nobs)
lat4 = rep(0,nobs)
long4 = rep(0,nobs)
dist4 = rep(0,nobs)
door4 = rep(0,nobs)
wing4 = rep(0,nobs)

####
#### Plastic
plastic = rep(0,nobs)
bottles.plas = plastic
sheet = plastic
bag = plastic
caps = plastic
fishline.mono = plastic
fishline.tang = plastic
synthrope = plastic
fishnet = plastic
cabletie = plastic
band = plastic
crates = plastic
nappies = plastic
sanitary = plastic
other.plas = plastic

####
#### Metals
metal = rep(0,nobs)
cans.food = metal
cans.drink = metal
fishing.met = metal
drums = metal
appliances = metal
carparts = metal
cables = metal
other.met = metal
####
#### Rubber
rubber = rep(0,nobs)
wellies = rubber
balloons = rubber
bobbins = rubber
tyre = rubber
gloves = rubber
other.rub = rubber
####
#### Glass
glass = rep(0,nobs)
jars = glass
bottles.glass = glass
pieces.glass = glass
other.glass = glass
####
#### Natural
natural = rep(0,nobs)
wood.proc = natural
rope = natural
paper = natural
pallets = natural
other.nat = natural
####
#### Miscellaneous
misc = rep(0,nobs)
clothing = misc
shoes = misc
other.misc = misc

####
#### Indicator variable to see whether "item()" from each row is allocated
#### to a litter category
####

used = rep(0, nobs)

k = 0
haul3.last = -99
for (j in 1:nobs) {
  if (haul3[j] != haul3.last) k = k + 1
  
  if (ltref3[j]=="C-TS-REV" ) {               # revised coding
  
  if (param3[j]=="A") {plastic[k] = plastic[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="A1") {bottles.plas[k] = bottles.plas[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="A2") {sheet[k] = sheet[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="A3") {bag[k] = bag[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="A4") {caps[k] = caps[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="A5") {fishline.mono[k] = fishline.mono[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="A6") {fishline.tang[k] = fishline.tang[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="A7") {synthrope[k] = synthrope[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="A8") {fishnet[k] = fishnet[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="A9") {cabletie[k] = cabletie[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="A10") {band[k] = band[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="A11") {crates[k] = crates[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="A12") {nappies[k] = nappies[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="A13") {sanitary[k] = sanitary[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="A14") {other.plas[k] = other.plas[k] + items3[j]; used[j]=used[j]+items3[j]}
  
  if (param3[j]=="B") {metal[k] = metal[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="B1") {cans.food[k] = cans.food[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="B2") {cans.drink[k] = cans.drink[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="B3") {fishing.met[k] = fishing.met[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="B4") {drums[k] = drums[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="B5") {appliances[k] = appliances[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="B6") {carparts[k] = carparts[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="B7") {cables[k] = cables[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="B8") {other.met[k] = other.met[k] + items3[j]; used[j]=used[j]+items3[j]}
  
  if (param3[j]=="C") {rubber[k] = rubber[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="C1") {wellies[k] = wellies[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="C2") {balloons[k] = balloons[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="C3") {bobbins[k] = bobbins[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="C4") {tyre[k] = tyre[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="C5") {gloves[k] = gloves[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="C6") {other.rub[k] = other.rub[k] + items3[j]; used[j]=used[j]+items3[j]}
  
  if (param3[j]=="D") {glass[k] = glass[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="D1") {jars[k] = jars[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="D2") {bottles.glass[k] = bottles.glass[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="D3") {pieces.glass[k] = pieces.glass[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="D4") {other.glass[k] = other.glass[k] + items3[j]; used[j]=used[j]+items3[j]}
  
  if (param3[j]=="E") {natural[k] = natural[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="E1") {wood.proc[k] = wood.proc[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="E2") {rope[k] = rope[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="E3") {paper[k] = paper[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="E4") {pallets[k] = pallets[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="E5") {other.nat[k] = other.nat[k] + items3[j]; used[j]=used[j]+items3[j]}
  
  if (param3[j]=="F") {misc[k] = misc[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="F1") {clothing[k] = clothing[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="F2") {shoes[k] = shoes[k] + items3[j]; used[j]=used[j]+items3[j]}
  if (param3[j]=="F3") {other.misc[k] = other.misc[k] + items3[j]; used[j]=used[j]+items3[j]}
  }
  
  if (ltref3[j]=="C-TS") {               # original coding
    
    if (param3[j]=="A") {plastic[k] = plastic[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="A1") {bottles.plas[k] = bottles.plas[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="A2") {sheet[k] = sheet[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="A3") {bag[k] = bag[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="A4") {caps[k] = caps[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="A5") {fishline.mono[k] = fishline.mono[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="A6") {fishline.tang[k] = fishline.tang[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="A7") {synthrope[k] = synthrope[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="A8") {fishnet[k] = fishnet[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="A9") {cabletie[k] = cabletie[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="A10") {band[k] = band[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="A11") {crates[k] = crates[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="A12") {other.plas[k] = other.plas[k] + items3[j]; used[j]=used[j]+items3[j]}
    
    if (param3[j]=="B") {sanitary[k] = sanitary[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="B1") {nappies[k] = nappies[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="B2") {other.plas[k] = other.plas[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="B3") {other.plas[k] = other.plas[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="B4") {other.plas[k] = other.plas[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="B5") {other.plas[k] = other.plas[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="B6") {sanitary[k] = sanitary[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="B7") {other.plas[k] = other.plas[k] + items3[j]; used[j]=used[j]+items3[j]}

    if (param3[j]=="C") {metal[k] = metal[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="C1") {cans.food[k] = cans.food[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="C2") {cans.drink[k] = cans.drink[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="C3") {fishing.met[k] = fishing.met[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="C4") {drums[k] = drums[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="C5") {appliances[k] = appliances[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="C6") {carparts[k] = carparts[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="C7") {cables[k] = cables[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="C8") {other.met[k] = other.met[k] + items3[j]; used[j]=used[j]+items3[j]}
    
    if (param3[j]=="D") {rubber[k] = rubber[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="D1") {wellies[k] = wellies[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="D2") {balloons[k] = balloons[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="D3") {bobbins[k] = bobbins[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="D4") {tyre[k] = tyre[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="D5") {gloves[k] = gloves[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="D6") {other.rub[k] = other.rub[k] + items3[j]; used[j]=used[j]+items3[j]}
    
    if (param3[j]=="E") {glass[k] = glass[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="E1") {jars[k] = jars[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="E2") {bottles.glass[k] = bottles.glass[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="E3") {pieces.glass[k] = pieces.glass[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="E4") {other.glass[k] = other.glass[k] + items3[j]; used[j]=used[j]+items3[j]}
    
    if (param3[j]=="F") {natural[k] = natural[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="F1") {wood.proc[k] = wood.proc[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="F2") {rope[k] = rope[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="F3") {paper[k] = paper[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="F4") {pallets[k] = pallets[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="F5") {other.nat[k] = other.nat[k] + items3[j]; used[j]=used[j]+items3[j]}
    
    if (param3[j]=="G") {misc[k] = misc[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="G1") {clothing[k] = clothing[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="G2") {shoes[k] = shoes[k] + items3[j]; used[j]=used[j]+items3[j]}
    if (param3[j]=="G3") {other.misc[k] = other.misc[k] + items3[j]; used[j]=used[j]+items3[j]}
  }
  
  region4[k] = region3[j]
  country4[k] = country3[j]
  gear4[k] = gear3[j]
  survey4[k] = survey3[j]
  stat4[k] = stat3[j]
  haul4[k] = haul3[j]
  ltref4[k] = ltref3[j]
  param4[k] = param3[j]
  items4[k] = items[j]
  day4[k] = day3[j]
  month4[k] = month3[j]
  year4[k] = year3[j]
  daynight4[k] = daynight3[j]
  lat4[k] = lat3[j]
  long4[k] = long3[j]
  dist4[k] = dist3[j]
  door4[k] = door3[j]
  wing4[k] = wing3[j]
  
  haul3.last = haul3[j]
}
new.len = k                              # 2254 rows

plastic = plastic[1:new.len]
bottles.plas = bottles.plas[1:new.len]
sheet = sheet[1:new.len]
bag = bag[1:new.len]
caps = caps[1:new.len]
fishline.mono = fishline.mono[1:new.len]
fishline.tang = fishline.tang[1:new.len]
synthrope = synthrope[1:new.len]
fishnet = fishnet[1:new.len]
cabletie = cabletie[1:new.len]
band = band[1:new.len]
crates = crates[1:new.len]
nappies = nappies[1:new.len]
sanitary = sanitary[1:new.len]
other.plas = other.plas[1:new.len]

metal = metal[1:new.len]
cans.food = cans.food[1:new.len]
cans.drink = cans.drink[1:new.len]
fishing.met = fishing.met[1:new.len]
drums = drums[1:new.len]
appliances = appliances[1:new.len]
carparts = carparts[1:new.len]
cables = cables[1:new.len]
other.met = other.met[1:new.len]

rubber = rubber[1:new.len]
wellies = wellies[1:new.len]
balloons = balloons[1:new.len]
bobbins = bobbins[1:new.len]
tyre = tyre[1:new.len]
gloves = gloves[1:new.len]
other.rub = other.rub[1:new.len]

glass = glass[1:new.len]
jars = jars[1:new.len]
bottles.glass = bottles.glass[1:new.len]
pieces.glass = pieces.glass[1:new.len]
other.glass = other.glass[1:new.len]

natural = natural[1:new.len]
wood.proc = wood.proc[1:new.len]
rope = rope[1:new.len]
paper = paper[1:new.len]
pallets = pallets[1:new.len]
other.nat = other.nat[1:new.len]

misc = misc[1:new.len]
clothing = clothing[1:new.len]
shoes = shoes[1:new.len]
other.misc = other.misc[1:new.len]

region4 = region4[1:new.len]
country4 = country4[1:new.len]
gear4 = gear4[1:new.len]
survey4 = survey4[1:new.len]
stat4 = stat4[1:new.len]
haul4 = haul4[1:new.len]
ltref4 = ltref4[1:new.len]
param4 = param4[1:new.len]
day4 = day4[1:new.len]
month4 = month4[1:new.len]
year4 = year4[1:new.len]
daynight4 = daynight4[1:new.len]
lat4 = lat4[1:new.len]
long4 = long4[1:new.len]
dist4 = dist4[1:new.len]
door4 = door4[1:new.len]
wing4 = wing4[1:new.len]

####
#### We seems to have gone from 4548 rows to 2254 rows (ie distinct trawls)
#### We should CHECK that this seems right using TABLE
####

plastic.tot = plastic + bottles.plas + sheet + bag + caps + fishline.mono +
  fishline.tang + synthrope + fishnet + cabletie + band + crates + nappies +
  sanitary + other.plas

metal.tot = metal + cans.food + cans.drink + fishing.met + drums + appliances +
  carparts + cables + other.met

rubber.tot = rubber + wellies + balloons + bobbins + tyre + gloves + other.rub

glass.tot = glass + jars + bottles.glass + pieces.glass + other.glass

natural.tot = natural + wood.proc + rope + paper + pallets + other.nat

misc.tot= misc + clothing + shoes + other.misc

litter.tot = plastic.tot + metal.tot + rubber.tot + glass.tot + natural.tot + misc.tot

table(used)                       # all 1s. So every line of item is used

####
#### Some repeating of the same category for the same
#### station (400 or so items) MAYBE?
####

litter.bin = ifelse(litter.tot>0.5, 1, 0)
plastic.bin = ifelse(plastic.tot>0.5, 1, 0)
metal.bin = ifelse(metal.tot>0.5, 1, 0)
rubber.bin = ifelse(rubber.tot>0.5, 1, 0)
glass.bin = ifelse(glass.tot>0.5, 1, 0)
natural.bin = ifelse(natural.tot>0.5, 1, 0)
misc.bin = ifelse(misc.tot>0.5, 1, 0)

####
#### Data summaries
####
table(year4)
table(year4, region4)


sum(litter.tot)                 # 6582
sum(items3)                     # 6584 Because 2 items down for 0 hauls

library(maps)       
library(mapdata)
library(sp)

####
#### Note that sampling doesn't look quite random. There could be biases
#### due to uneven sampling.
####

par(mfrow=c(2,2), mar=c(1,1,2,1), pty='s')

map("world",xlim=range(-15.3,21.3,na.rm=T),ylim=range(36.0,61.3),fill=T,col="white")
points(long4[region4=="GNS" & year4==2012], lat4[region4=="GNS" & year4==2012], col=2)
points(long4[region4=="Celtic" & year4==2012], lat4[region4=="Celtic" & year4==2012], col=3)
points(long4[region4=="Biscay" & year4==2012], lat4[region4=="Biscay" & year4==2012], col=4)
map.axes()
#title("2012 GOV sampling locations")
title("2012 BAK sampling locations")
#legend('bottomright', legend=c("GNS", "Celtic", "Biscay"), pch=c(1,1,1),
#       col=c(2,3,4))

map("world",xlim=range(-15.3,21.3,na.rm=T),ylim=range(36.0,61.3),fill=T,col="white")
points(long4[region4=="GNS" & year4==2013], lat4[region4=="GNS" & year4==2013], col=2)
points(long4[region4=="Celtic" & year4==2013], lat4[region4=="Celtic" & year4==2013], col=3)
points(long4[region4=="Biscay" & year4==2013], lat4[region4=="Biscay" & year4==2013], col=4)
map.axes()
title("2013 BAK sampling locations")
#title("2013 GOV sampling locations")
#legend('bottomright', legend=c("GNS", "Celtic", "Biscay"), pch=c(1,1,1),
#      col=c(2,3,4))

map("world",xlim=range(-15.3,21.3,na.rm=T),ylim=range(36.0,61.3),fill=T,col="white")
points(long4[region4=="GNS" & year4==2014], lat4[region4=="GNS" & year4==2014], col=2)
points(long4[region4=="Celtic" & year4==2014], lat4[region4=="Celtic" & year4==2014], col=3)
points(long4[region4=="Biscay" & year4==2014], lat4[region4=="Biscay" & year4==2014], col=4)
map.axes()
title("2014 BAK sampling locations")
#title("2014 GOV sampling locations")
#legend('bottomright', legend=c("GNS", "Celtic", "Biscay"), pch=c(1,1,1),
#       col=c(2,3,4))

####
#### 2014 sampling locations only
####
par(mfrow=c(1,1))

map("world",xlim=range(-15.3,21.3,na.rm=T),ylim=range(36.0,61.3),fill=T,col="white")
points(long4[region4=="GNS" & year4==2014], lat4[region4=="GNS" & year4==2014], col=1)
points(long4[region4=="Celtic" & year4==2014], lat4[region4=="Celtic" & year4==2014], col=3)
points(long4[region4=="Biscay" & year4==2014], lat4[region4=="Biscay" & year4==2014], col=4)
map.axes()
#title("2014 BAK sampling locations")

table(region4)        # Biscay=208 Celtic=689 GNS=1357
table(region4, year4)

sum(is.na(wing4))                                # 802
sum(is.na(door4))                                # 140
sum(is.na(dist4))                                # 133

####
#### So use door4 for RELATIVE size of net as not so many missing values
#### I think we should use (1) litter per km2 (2) proportion containing
#### (3) counts per net in tables. We could then produce smoothed maps
#### using the software I generated previously.
#### Could also stratify using the smoothed estimates to stop the bias.
####

#### NEED TO MULTIPLY BY THE 4.18 HERE

ratio = door4 / wing4              # 4.18 for GOV, 5.00 for BAK (51 pairs, 488 missing)
mean(ratio, na.rm=T)
sum(is.na(ratio)); length(ratio)   # 818 missing, 2254 length for GOV

doortowing = 4.18

trawlarea = dist4 * door4 / 1000000

plastic.tot.km2 = doortowing * plastic.tot / trawlarea
metal.tot.km2 = doortowing * metal.tot / trawlarea
rubber.tot.km2 = doortowing * rubber.tot / trawlarea
glass.tot.km2 = doortowing * glass.tot / trawlarea
natural.tot.km2 = doortowing * natural.tot / trawlarea
misc.tot.km2 = doortowing * misc.tot / trawlarea
litter.tot.km2 = doortowing * litter.tot / trawlarea

newdata = cbind(trawlarea, plastic.tot.km2, metal.tot.km2, rubber.tot.km2, glass.tot.km2,
      natural.tot.km2, misc.tot.km2, litter.tot.km2, plastic.bin, litter.bin,
      metal.bin, rubber.bin, glass.bin, natural.bin, misc.bin, plastic,
      bottles.plas, sheet, bag, caps, fishline.mono, fishline.tang, synthrope,
      fishnet, cabletie, band, crates, nappies, sanitary, other.plas, metal,
      cans.food, cans.drink, fishing.met, drums, appliances, carparts, cables,
      other.met, rubber, wellies, balloons, bobbins, tyre, gloves, other.rub,
      glass, jars, bottles.glass, pieces.glass, other.glass, natural, wood.proc,
      rope, paper, pallets, other.nat, misc, clothing, shoes, other.misc,
      region4, country4, gear4, survey4, stat4, haul4, ltref4, param4, day4,
      month4, year4, daynight4, lat4, long4, dist4, door4, wing4)

#write.csv(newdata, file="newdata.csv", row.names=F)


#### Summaries per haul area

#### Total litter

tapply(litter.tot.km2, list(region4, year4), mean, na.rm=T)
tapply(litter.tot.km2, list(region4, year4), median, na.rm=T)

clean = !is.na(litter.tot.km2[year4==2012 & region4=="GNS"])
bootstrap(litter.tot.km2[year4==2012 & region4=="GNS"][clean])$perc
clean = !is.na(litter.tot.km2[year4==2013 & region4=="GNS"])
bootstrap(litter.tot.km2[year4==2013 & region4=="GNS"][clean])$perc
clean = !is.na(litter.tot.km2[year4==2014 & region4=="GNS"])
bootstrap(litter.tot.km2[year4==2014 & region4=="GNS"][clean])$perc

clean = !is.na(litter.tot.km2[year4==2012 & region4=="Celtic"])
bootstrap(litter.tot.km2[year4==2012 & region4=="Celtic"][clean])$perc
clean = !is.na(litter.tot.km2[year4==2013 & region4=="Celtic"])
bootstrap(litter.tot.km2[year4==2013 & region4=="Celtic"][clean])$perc
clean = !is.na(litter.tot.km2[year4==2014 & region4=="Celtic"])
bootstrap(litter.tot.km2[year4==2014 & region4=="Celtic"][clean])$perc

clean = !is.na(litter.tot.km2[year4==2013 & region4=="Biscay"])
bootstrap(litter.tot.km2[year4==2013 & region4=="Biscay"][clean])$perc
clean = !is.na(litter.tot.km2[year4==2014 & region4=="Biscay"])
bootstrap(litter.tot.km2[year4==2014 & region4=="Biscay"][clean])$perc

#### Plastic litter

tapply(plastic.tot.km2, list(region4, year4), mean, na.rm=T)
tapply(plastic.tot.km2, list(region4, year4), median, na.rm=T)

clean = !is.na(plastic.tot.km2[year4==2012 & region4=="Celtic"])
bootstrap(plastic.tot.km2[year4==2012 & region4=="Celtic"][clean])$perc
clean = !is.na(plastic.tot.km2[year4==2013 & region4=="Celtic"])
bootstrap(plastic.tot.km2[year4==2013 & region4=="Celtic"][clean])$perc
clean = !is.na(plastic.tot.km2[year4==2014 & region4=="Celtic"])
bootstrap(plastic.tot.km2[year4==2014 & region4=="Celtic"][clean])$perc

clean = !is.na(plastic.tot.km2[year4==2012 & region4=="GNS"])
bootstrap(plastic.tot.km2[year4==2012 & region4=="GNS"][clean])$perc
clean = !is.na(plastic.tot.km2[year4==2013 & region4=="GNS"])
bootstrap(plastic.tot.km2[year4==2013 & region4=="GNS"][clean])$perc
clean = !is.na(plastic.tot.km2[year4==2014 & region4=="GNS"])
bootstrap(plastic.tot.km2[year4==2014 & region4=="GNS"][clean])$perc

clean = !is.na(plastic.tot.km2[year4==2013 & region4=="Biscay"])
bootstrap(plastic.tot.km2[year4==2013 & region4=="Biscay"][clean])$perc
clean = !is.na(plastic.tot.km2[year4==2014 & region4=="Biscay"])
bootstrap(plastic.tot.km2[year4==2014 & region4=="Biscay"][clean])$perc

tapply(metal.tot.km2, list(region4, year4), mean, na.rm=T)
tapply(metal.tot.km2, list(region4, year4), median, na.rm=T)

tapply(rubber.tot.km2, list(region4, year4), mean, na.rm=T)
tapply(rubber.tot.km2, list(region4, year4), median, na.rm=T)

tapply(glass.tot.km2, list(region4, year4), mean, na.rm=T)
tapply(glass.tot.km2, list(region4, year4), median, na.rm=T)

tapply(natural.tot.km2, list(region4, year4), mean, na.rm=T)
tapply(natural.tot.km2, list(region4, year4), median, na.rm=T)

tapply(misc.tot.km2, list(region4, year4), mean, na.rm=T)
tapply(misc.tot.km2, list(region4, year4), median, na.rm=T)

#### summaries per haul counts

#### Total litter

tapply(litter.tot, list(region4, year4), mean)
tapply(litter.tot, list(region4, year4), median)

clean = !is.na(litter.tot[year4==2012 & region4=="Celtic"])
bootstrap(litter.tot[year4==2012 & region4=="Celtic"][clean])$perc
clean = !is.na(litter.tot[year4==2013 & region4=="Celtic"])
bootstrap(litter.tot[year4==2013 & region4=="Celtic"][clean])$perc
clean = !is.na(litter.tot[year4==2014 & region4=="Celtic"])
bootstrap(litter.tot[year4==2014 & region4=="Celtic"][clean])$perc

clean = !is.na(litter.tot[year4==2012 & region4=="GNS"])
bootstrap(litter.tot[year4==2012 & region4=="GNS"][clean])$perc
clean = !is.na(litter.tot[year4==2013 & region4=="GNS"])
bootstrap(litter.tot[year4==2013 & region4=="GNS"][clean])$perc
clean = !is.na(litter.tot[year4==2014 & region4=="GNS"])
bootstrap(litter.tot[year4==2014 & region4=="GNS"][clean])$perc

clean = !is.na(litter.tot[year4==2012 & region4=="Biscay"])
bootstrap(litter.tot[year4==2012 & region4=="Biscay"][clean])$perc
clean = !is.na(litter.tot[year4==2013 & region4=="Biscay"])
bootstrap(litter.tot[year4==2013 & region4=="Biscay"][clean])$perc
clean = !is.na(litter.tot[year4==2014 & region4=="Biscay"])
bootstrap(litter.tot[year4==2014 & region4=="Biscay"][clean])$perc

#### Plastic total

clean = !is.na(plastic.tot[year4==2012 & region4=="Celtic"])
bootstrap(plastic.tot[year4==2012 & region4=="Celtic"][clean])$perc
clean = !is.na(plastic.tot[year4==2013 & region4=="Celtic"])
bootstrap(plastic.tot[year4==2013 & region4=="Celtic"][clean])$perc
clean = !is.na(plastic.tot[year4==2014 & region4=="Celtic"])
bootstrap(plastic.tot[year4==2014 & region4=="Celtic"][clean])$perc

clean = !is.na(plastic.tot[year4==2012 & region4=="GNS"])
bootstrap(plastic.tot[year4==2012 & region4=="GNS"][clean])$perc
clean = !is.na(plastic.tot[year4==2013 & region4=="GNS"])
bootstrap(plastic.tot[year4==2013 & region4=="GNS"][clean])$perc
clean = !is.na(plastic.tot[year4==2014 & region4=="GNS"])
bootstrap(plastic.tot[year4==2014 & region4=="GNS"][clean])$perc

clean = !is.na(plastic.tot[year4==2012 & region4=="Biscay"])
bootstrap(plastic.tot[year4==2012 & region4=="Biscay"][clean])$perc
clean = !is.na(plastic.tot[year4==2013 & region4=="Biscay"])
bootstrap(plastic.tot[year4==2013 & region4=="Biscay"][clean])$perc
clean = !is.na(plastic.tot[year4==2014 & region4=="Biscay"])
bootstrap(plastic.tot[year4==2014 & region4=="Biscay"][clean])$perc

tapply(plastic.tot, list(region4, year4), mean)
tapply(plastic.tot, list(region4, year4), median)

tapply(metal.tot, list(region4, year4), mean)
tapply(metal.tot, list(region4, year4), median)

tapply(rubber.tot, list(region4, year4), mean)
tapply(rubber.tot, list(region4, year4), median)

tapply(glass.tot, list(region4, year4), mean)
tapply(glass.tot, list(region4, year4), median)

tapply(natural.tot, list(region4, year4), mean)
tapply(natural.tot, list(region4, year4), median)

tapply(misc.tot, list(region4, year4), mean)
tapply(misc.tot, list(region4, year4), median)

#### summaries per proportion

#### Total litter binary

tapply(litter.bin, list(region4, year4), mean)
tapply(litter.bin, list(region4, year4), median)

clean = !is.na(litter.bin[year4==2012 & region4=="Celtic"])
bootstrap(litter.bin[year4==2012 & region4=="Celtic"][clean])$perc
clean = !is.na(litter.bin[year4==2013 & region4=="Celtic"])
bootstrap(litter.bin[year4==2013 & region4=="Celtic"][clean])$perc
clean = !is.na(litter.bin[year4==2014 & region4=="Celtic"])
bootstrap(litter.bin[year4==2014 & region4=="Celtic"][clean])$perc

clean = !is.na(litter.bin[year4==2012 & region4=="GNS"])
bootstrap(litter.bin[year4==2012 & region4=="GNS"][clean])$perc
clean = !is.na(litter.bin[year4==2013 & region4=="GNS"])
bootstrap(litter.bin[year4==2013 & region4=="GNS"][clean])$perc
clean = !is.na(litter.bin[year4==2014 & region4=="GNS"])
bootstrap(litter.bin[year4==2014 & region4=="GNS"][clean])$perc

clean = !is.na(litter.bin[year4==2012 & region4=="Biscay"])
bootstrap(litter.bin[year4==2012 & region4=="Biscay"][clean])$perc
clean = !is.na(litter.bin[year4==2013 & region4=="Biscay"])
bootstrap(litter.bin[year4==2013 & region4=="Biscay"][clean])$perc
clean = !is.na(litter.bin[year4==2014 & region4=="Biscay"])
bootstrap(litter.bin[year4==2014 & region4=="Biscay"][clean])$perc

#### Plastic binary

tapply(plastic.bin, list(region4, year4), mean)
tapply(plastic.bin, list(region4, year4), median)

clean = !is.na(plastic.bin[year4==2012 & region4=="Celtic"])
bootstrap(plastic.bin[year4==2012 & region4=="Celtic"][clean])$perc
clean = !is.na(plastic.bin[year4==2013 & region4=="Celtic"])
bootstrap(plastic.bin[year4==2013 & region4=="Celtic"][clean])$perc
clean = !is.na(plastic.bin[year4==2014 & region4=="Celtic"])
bootstrap(plastic.bin[year4==2014 & region4=="Celtic"][clean])$perc

clean = !is.na(plastic.bin[year4==2012 & region4=="GNS"])
bootstrap(plastic.bin[year4==2012 & region4=="GNS"][clean])$perc
clean = !is.na(plastic.bin[year4==2013 & region4=="GNS"])
bootstrap(plastic.bin[year4==2013 & region4=="GNS"][clean])$perc
clean = !is.na(plastic.bin[year4==2014 & region4=="GNS"])
bootstrap(plastic.bin[year4==2014 & region4=="GNS"][clean])$perc

clean = !is.na(plastic.bin[year4==2012 & region4=="Biscay"])
bootstrap(plastic.bin[year4==2012 & region4=="Biscay"][clean])$perc
clean = !is.na(plastic.bin[year4==2013 & region4=="Biscay"])
bootstrap(plastic.bin[year4==2013 & region4=="Biscay"][clean])$perc
clean = !is.na(plastic.bin[year4==2014 & region4=="Biscay"])
bootstrap(plastic.bin[year4==2014 & region4=="Biscay"][clean])$perc

tapply(metal.bin, list(region4, year4), mean)
tapply(metal.bin, list(region4, year4), median)

tapply(rubber.bin, list(region4, year4), mean)
tapply(rubber.bin, list(region4, year4), median)

tapply(glass.bin, list(region4, year4), mean)
tapply(glass.bin, list(region4, year4), median)

tapply(natural.bin, list(region4, year4), mean)
tapply(natural.bin, list(region4, year4), median)

tapply(misc.bin, list(region4, year4), mean)
tapply(misc.bin, list(region4, year4), median)

####
#### Proportion of litter that is plastic in each region
####

tapply(plastic.tot, list(region4, year4), sum) / tapply(litter.tot, list(region4, year4), sum)

####
#### Try mapping whether a haul contains plastic or not
####

source('Keith functions.R')

setup = bander.setup(xlimit=c(-15,15), ylimit=c(43,62), nx=200,
            latt=lat4, longg=long4, minsep=20000)

par(mfrow=c(1,1))

#NEED GRAPHICS RESET PARAMETER = t. BUT PLOT REGIONS ARE STILL NOT RIGHT

tapply(plastic.bin, region4, mean)

prob.plastic.map = smooth.gam(Yvar = plastic.bin, include=setup,
           latitude=lat4, longitude=long4, type='bin')

map("world",xlim=range(-15,15,na.rm=T),ylim=range(43,62),fill=T,col='white')
#image.plot(setup$xgrid, setup$ygrid, prob.plastic.map, add=T, col=tim.colors())
image.plot(setup$xgrid, setup$ygrid, prob.plastic.map, add=T,
                     col=rainbow(n=12, start=0.2))
#points(long4, lat4, col='black',cex=0.05,pch=19)
#title(main="Probability haul contains plastic", xlab=" ", ylab=" ")
#map.axes()


min(prob.plastic.map, na.rm=T)                 # 0.16
max(prob.plastic.map, na.rm=T)                 # 0.98

#*******************************

log.litter.tot.km2 = log(litter.tot.km2 + 1)

litter.tot.km2.map = smooth.gam(Yvar = log.litter.tot.km2, include=setup,
                  latitude=lat4, longitude=long4, type='norm')


map("world",xlim=range(-15,15,na.rm=T),ylim=range(43,62),fill=T,col='white')
image.plot(setup$xgrid, setup$ygrid, (exp(litter.tot.km2.map)-1), add=T,
           graphics.reset=T, col=rainbow(12,start=0.2))
#points(long4, lat4, col='black',cex=0.05,pch=19)
#title(main="Total litter per km2", xlab=" ", ylab=" ")
#map.axes()

#***********************************************
#### Decided not to standardise for doortowing for counts. It is done
#### in litter per km2

ggg = litter.tot * doortowing

litter.tot.map = smooth.gam(Yvar = litter.tot, include=setup,
                                latitude=lat4, longitude=long4, type='nb')

# Note that the map scale is on the log scale
# exp(0.5)=1.6, exp(3.5)=33.1

map("world",xlim=range(-15,15,na.rm=T),ylim=range(43,62),fill=T,col='white')
image.plot(setup$xgrid, setup$ygrid, litter.tot.map, add=T, graphics.reset=T,
           col=rainbow(12, start=0.2))
#points(long4, lat4, col='black',cex=0.05,pch=19)
##title(main="Total litter", xlab=" ", ylab=" ")
#map.axes()

#******************************************************

fff = plastic.tot*doortowing

plastic.tot.map = smooth.gam(Yvar = plastic.tot, include=setup,
                  latitude=lat4, longitude=long4, type='nb')

# Note that the map scale is on the log scale
# exp(0.5)=1.6, exp(3.5)=33.1

map("world",xlim=range(-15,15,na.rm=T),ylim=range(43,62),fill=T,col='white')
image.plot(setup$xgrid, setup$ygrid, plastic.tot.map, add=T,
           col=rainbow(12, start=0.2))
#points(long4, lat4, col='black',cex=0.05,pch=19)
#title(main="Total plastic", xlab=" ", ylab=" ")
#map.axes()


min(prob.plastic, na.rm=T)                 # 0.16
max(prob.plastic, na.rm=T)                 # 0.98




smooth.gam = function(Yvar, include, latitude, longitude, type) {
  #************************************************************
  # Yvar: Y data to be smoothed
  # INCLUDE: bander.setup(), defines the area for smoothing
  # SPECIES.SMOOTH: Name of species for smoothing
  # LATITUDE: Positions of Ydata
  # LONGITUDE: Positions of Ydata
  # TYPE: Form of the Y-variable
  #************************************************************
  
  if (type=='bin') {
    mod.bin = gam(Yvar ~ s(latitude) + s(longitude), family=binomial)
  }
  
  if (type=='norm') {
    mod.bin = gam(Yvar ~ s(latitude) + s(longitude), family=gaussian)
  }
  
  if (type=='pois') {
    mod.bin = gam(Yvar ~ s(latitude) + s(longitude), family=poisson)
  }
  
  if (type=='nb') {
    mod.bin = gam(Yvar ~ s(latitude) + s(longitude), family=nb)
  }
  
  #### Do prediction for included grid points
  
  ylong = include$ylong
  xlong = include$xlong
  bandTF = include$band
  new.cords = data.frame(latitude=ylong, longitude=xlong)
  
  zlong = predict(mod.bin, newdata=new.cords, type="response")
  
  #### Now need to insert these zlong values back into the correct place
  #### in the matrix. Need to get rows and columns the right way round
  
  bandnew = slotter(band=bandTF, zlong)
  
  bandnew
}

####
#### If we carry on with the same sample sizes, how long will it
#### take to detect changes of 10%, 20%, 30% etc
####

library(emon)

table(year4,region4)   # Biscay 75, Celtic 225, GNS 500

#exp(tapply(log.litter.tot.km2, list(year4,region4), mean, na.rm=T))-1
#tapply(litter.tot.km2, list(year4,region4), mean, na.rm=T)

library(MASS)

tapply(litter.tot, list(year4,region4), mean)

#### Celtic power

celtic.nb = fitdistr(litter.tot[year4==2012 & region4=="Celtic"],
                     "Negative Binomial")
year.vec = seq(5,30,5)
celtpower10 = rep(0, length(year.vec))
celtpower20 = rep(0, length(year.vec))
celtpower30 = rep(0, length(year.vec))

j=0
for (ny in year.vec) {

j= j + 1
signal = generate.trend(nyears=ny, mu1=1.91, change=10, change.type="M",
                        type="linear")
celtpower10[j] = power.trend(signal$i, reps=225, meanvalues=signal$mu, distribution="Negbin",
            nbsize=celtic.nb$est[1])
signal = generate.trend(nyears=ny, mu1=1.91, change=20, change.type="M",
                        type="linear")
celtpower20[j] = power.trend(signal$i, reps=225, meanvalues=signal$mu, distribution="Negbin",
                             nbsize=celtic.nb$est[1])
signal = generate.trend(nyears=ny, mu1=1.91, change=30, change.type="M",
                        type="linear")
celtpower30[j] = power.trend(signal$i, reps=225, meanvalues=signal$mu, distribution="Negbin",
                             nbsize=celtic.nb$est[1])
}

#### GNS power

GNS.nb = fitdistr(litter.tot[year4==2012 & region4=="GNS"],
                     "Negative Binomial")
year.vec = seq(5,30,5)
GNSpower10 = rep(0, length(year.vec))
GNSpower20 = rep(0, length(year.vec))
GNSpower30 = rep(0, length(year.vec))

j=0
for (ny in year.vec) {
  
  j= j + 1
  signal = generate.trend(nyears=ny, mu1=1.61, change=10, change.type="M",
                          type="linear")
  GNSpower10[j] = power.trend(signal$i, reps=500, meanvalues=signal$mu, distribution="Negbin",
                               nbsize=GNS.nb$est[1])
  signal = generate.trend(nyears=ny, mu1=1.61, change=20, change.type="M",
                          type="linear")
  GNSpower20[j] = power.trend(signal$i, reps=500, meanvalues=signal$mu, distribution="Negbin",
                               nbsize=GNS.nb$est[1])
  signal = generate.trend(nyears=ny, mu1=1.61, change=30, change.type="M",
                          type="linear")
  GNSpower30[j] = power.trend(signal$i, reps=500, meanvalues=signal$mu, distribution="Negbin",
                               nbsize=GNS.nb$est[1])
}

#### Biscay power

biscay.nb = fitdistr(litter.tot[year4==2012 & region4=="Biscay"],
                  "Negative Binomial")
year.vec = seq(5,30,5)
biscaypower10 = rep(0, length(year.vec))
biscaypower20 = rep(0, length(year.vec))
biscaypower30 = rep(0, length(year.vec))

j=0
for (ny in year.vec) {
  
  j= j + 1
  signal = generate.trend(nyears=ny, mu1=1.61, change=10, change.type="M",
                          type="linear")
  biscaypower10[j] = power.trend(signal$i, reps=75, meanvalues=signal$mu, distribution="Negbin",
                              nbsize=biscay.nb$est[1])
  signal = generate.trend(nyears=ny, mu1=1.61, change=20, change.type="M",
                          type="linear")
  biscaypower20[j] = power.trend(signal$i, reps=75, meanvalues=signal$mu, distribution="Negbin",
                              nbsize=biscay.nb$est[1])
  signal = generate.trend(nyears=ny, mu1=1.61, change=30, change.type="M",
                          type="linear")
  biscaypower30[j] = power.trend(signal$i, reps=75, meanvalues=signal$mu, distribution="Negbin",
                              nbsize=biscay.nb$est[1])
}

#### Spain power

#biscay.nb = fitdistr(litter.tot[year4==2012 & region4=="Biscay"],
#                     "Negative Binomial")
#year.vec = seq(5,30,5)
#spainpower10 = rep(0, length(year.vec))
#spainpower20 = rep(0, length(year.vec))
#spainpower30 = rep(0, length(year.vec))

#j=0
#for (ny in year.vec) {
  
#  j= j + 1
#  signal = generate.trend(nyears=ny, mu1=1.61, change=10, change.type="M",
#                          type="linear")
#  spainpower10[j] = power.trend(signal$i, reps=182, meanvalues=signal$mu, distribution="Negbin",
#                                 nbsize=biscay.nb$est[1])
#  signal = generate.trend(nyears=ny, mu1=1.61, change=20, change.type="M",
#                          type="linear")
#  spainpower20[j] = power.trend(signal$i, reps=182, meanvalues=signal$mu, distribution="Negbin",
#                                 nbsize=biscay.nb$est[1])
#  signal = generate.trend(nyears=ny, mu1=1.61, change=30, change.type="M",
#                          type="linear")
#  spainpower30[j] = power.trend(signal$i, reps=182, meanvalues=signal$mu, distribution="Negbin",
#                                 nbsize=biscay.nb$est[1])
#}

#par(mfrow=c(1,1))
#plot(year.vec, spainpower10, ylim=c(0,1), ylab='Power', xlab='Years', col=1, lty=1, type='l')
#lines(year.vec, spainpower20, col=2, lty=2)
#lines(year.vec, spainpower30, col=3, lty=3)
#legend('bottomleft', legend=c("10%", "20%", "30%"), col=c(1,2,3), lty=c(1,2,3))
#abline(h=0.9, lty=2)
#title('Spain power vs survey years')


par(mfrow=c(2,2))
plot(year.vec, celtpower10, ylim=c(0,1), ylab='Power', xlab='Years', col=1, lty=1, type='l')
lines(year.vec, celtpower20, col=2, lty=2)
lines(year.vec, celtpower30, col=3, lty=3)
legend('bottomleft', legend=c("10%", "20%", "30%"), col=c(1,2,3), lty=c(1,2,3))
abline(h=0.9, lty=2)
title('Celtic power vs survey years')

plot(year.vec, GNSpower10, ylim=c(0,1), ylab='Power', xlab='Years', col=1, lty=1, type='l')
lines(year.vec, GNSpower20, col=2, lty=2)
lines(year.vec, GNSpower30, col=3, lty=3)
#legend('bottomleft', legend=c("10%", "20%", "30%"), col=c(1,2,3), lty=c(1,2,3))
abline(h=0.9, lty=2)
title('GNS power vs survey years')

plot(year.vec, biscaypower10, ylim=c(0,1), ylab='Power', xlab='Years', col=1, lty=1, type='l')
lines(year.vec, biscaypower20, col=2, lty=2)
lines(year.vec, biscaypower30, col=3, lty=3)
#legend('bottomleft', legend=c("10%", "20%", "30%"), col=c(1,2,3), lty=c(1,2,3))
abline(h=0.9, lty=2)
title('Biscay power vs survey years')



# OLD STUFF
#*************************************************
# LOOK AT 2011 ONLY AS THIS HAS ALL 8 SURVEYS
# ************************************************

# Map where these surveys are in 2011 using different colours and symbols
# FIGURE 2
survey.name = c('CSEMP', 'DBTS', 'IBTS', 'MEM', 'NWGFS', 'Q1SW', 'Q1SWB', 'Q4SW')
par(mfrow=c(1,1),mar=c(3,3,1,1))
plot(long[year==2011 & survey==survey.name[1]], lat[year==2011 & survey==survey.name[1]], xlim = c(minlong, maxlong), ylim = c(minlat, maxlat), col=1, pch=1, xlab=' ', ylab=' ')
for (j in 2:8) {
points(long[year==2011 & survey==survey.name[j]], lat[year==2011 & survey==survey.name[j]], col=j, pch=j)
}
map('worldHires', col="olivedrab", fill=T, add=T)
legend('topleft', legend=survey.name, col=1:8, pch=1:8)

# Look at summary statistics for each survey
# Looks like some big differences between surveys (i.e. areas)

tapply(litter.km2[year==2011], survey[year==2011], mean)
tapply(litter.km2[year==2011], survey[year==2011], median)
tapply(litter.km2[year==2011], survey[year==2011], length)

litter.km2[year==2011 & survey=='CSEMP']
litter.km2[year==2011 & survey=='Q1SWB']
litter.km2[year==2011 & survey=='DBTS']

# Could look at proportions of non-zeros for each survey too

prop = rep(0, 8)
for (j in 1:8) {
xx = litter.km2[year==2011 & survey==survey.name[j]]
prop[j] = 100 - length(xx[xx==0])*100 / length(xx)
}
round(prop, 1)

# Non-parametric analysis of variance: p =10-15

kruskal.test(litter.km2[year==2011] ~ factor(survey[year==2011]))

#*********************************************************************
# LOOK AT TEMPORAL EFFECTS FOR JUST THE IBTS SURVEYS
#*********************************************************************

year.plot = c(1992:2000, 2005, 2008:2011)
all.mean = tapply(litter.km2[survey=='IBTS'], year[survey=='IBTS'], mean)
plas.mean = tapply(litter.km2.plas[survey=='IBTS'], year[survey=='IBTS'], mean)
san.mean = tapply(litter.km2.san[survey=='IBTS'], year[survey=='IBTS'], mean)
met.mean = tapply(litter.km2.met[survey=='IBTS'], year[survey=='IBTS'], mean)
rub.mean = tapply(litter.km2.rub[survey=='IBTS'], year[survey=='IBTS'], mean)
glass.mean = tapply(litter.km2.glass[survey=='IBTS'], year[survey=='IBTS'], mean)
nat.mean = tapply(litter.km2.nat[survey=='IBTS'], year[survey=='IBTS'], mean)
misc.mean = tapply(litter.km2.misc[survey=='IBTS'], year[survey=='IBTS'], mean)

par(mfrow=c(3,3),mar=c(4,3,3,1.5))
plot(year.plot, all.mean, xlab=' ', type='b', main='Total (p=0.43)')
s = ksmooth(year.plot, all.mean, bandwidth=2, kernel=c("normal"), n.points=100)
#lines(s$x, s$y)

plot(year.plot, plas.mean, xlab=' ', type='b', main='Plastic (p=0.33)')
s = ksmooth(year.plot, plas.mean, bandwidth=2, kernel=c("normal"), n.points=100)
#lines(s$x, s$y)

plot(year.plot, san.mean, type='b', xlab=' ', main='Sanitary')
s = ksmooth(year.plot, san.mean, bandwidth=2, kernel=c("normal"), n.points=100)
#lines(s$x, s$y)

plot(year.plot, met.mean, type='b', xlab=' ', main='Metal (p=0.35)')
s = ksmooth(year.plot, met.mean, bandwidth=2, kernel=c("normal"), n.points=100)
#lines(s$x, s$y)

plot(year.plot, rub.mean, type='b', xlab=' ', main='Rubber (p=0.006)')
s = ksmooth(year.plot, rub.mean, bandwidth=2, kernel=c("normal"), n.points=100)
#lines(s$x, s$y)

plot(year.plot, glass.mean, type='b', xlab=' ', main='Glass (p=0.21)')
s = ksmooth(year.plot, glass.mean, bandwidth=2, kernel=c("normal"), n.points=100)
#lines(s$x, s$y)

plot(year.plot, nat.mean, type='b', xlab=' ', main='Natural (p=0.95)')
s = ksmooth(year.plot, nat.mean, bandwidth=2, kernel=c("normal"), n.points=100)
#lines(s$x, s$y)

plot(year.plot, misc.mean, type='b', xlab=' ', main='Misc (p=0.57)')
s = ksmooth(year.plot, misc.mean, bandwidth=2, kernel=c("normal"), n.points=100)
#lines(s$x, s$y)

# Calculate Mann-Kendall for each of these time series


mannkendall = function(year, stuff) {
# **************************************************************************************************
# This can do multiple values per year but also works for one value per year
# **************************************************************************************************
levels = as.integer(as.character(as.data.frame(table(year))[,1]))
freq = as.data.frame(table(year))[,2]
nlev = length(levels)
statistic = rep(0, (nlev-1))
stat = 0
for (k in 1:(nlev-1)) {
data.now = stuff[year == levels[k]]
data.future = stuff[year > levels[k]]
for (kk in 1:freq[k]) {
npos = length(data.future[data.future > data.now[kk]])
nneg = length(data.future[data.future < data.now[kk]])
stat = stat + (npos - nneg)
}
statistic[k] = stat
}
list(mk=stat, cummk=statistic)
}

mannkendall.rand = function(time, Y, nreps) {
#***************************************************
# Mann-Kendall trend and randomisation test
# Two way test so don't use "2" in p-value
#***************************************************
#
nreps = 999
N = length(Y)
theory = rep(0,nreps)
#
observed = mannkendall(time, Y)$mk
for (j in 1:nreps) {
rand = sample(Y, N, replace=F)
theory[j] = mannkendall(time, rand)$mk
}
ff = rank(c(abs(observed), abs(theory)))
p.trend = 1 - (ff[1] - 0.5)/ (nreps+1)
list(p=p.trend, mk=observed)
}

mannkendall.rand(year.plot, all.mean)
mannkendall.rand(year.plot, plas.mean)
mannkendall.rand(year.plot, san.mean)
mannkendall.rand(year.plot, met.mean)
mannkendall.rand(year.plot, rub.mean)
mannkendall.rand(year.plot, glass.mean)
mannkendall.rand(year.plot, nat.mean)
mannkendall.rand(year.plot, misc.mean)

#
# Look at PLASTICS for IBTS only
#
year.plot = c(1992:2000, 2005, 2008:2011)
#
# Don't trust the IBTS surveys in that i'm not convinced
# they have counted all of the items until the later years
#
year.IBTS = year[survey=='IBTS']
area.IBTS = area[survey=='IBTS']
area.IBTS2 = ifelse(area.IBTS==999, NA, area.IBTS)
round(tapply(area.IBTS2, year.IBTS, mean, na.rm=T),3)
# Areas seem very consistent over the years

bag.IBTS = bag[survey=='IBTS']
table(list(bag.IBTS,year.IBTS)) # mostly binary until 2010, 2011
bag.IBTS.bin = ifelse(bag.IBTS>0, 1, 0)

bottles.plas.IBTS = bottles.plas[survey=='IBTS']
table(list(bottles.plas.IBTS,year.IBTS)) # mostly binary until 2010, 2011
bottles.plas.IBTS.bin = ifelse(bottles.plas.IBTS>0, 1, 0)

sheet.IBTS = sheet[survey=='IBTS']
table(list(sheet.IBTS,year.IBTS)) # mostly binary until 2010, 2011
sheet.IBTS.bin = ifelse(sheet.IBTS>0, 1, 0)

caps.IBTS = caps[survey=='IBTS']
table(list(caps.IBTS,year.IBTS)) # mostly binary until 2010, 2011
caps.IBTS.bin = ifelse(caps.IBTS>0, 1, 0)

bag.IBTS = bag[survey=='IBTS']
table(list(bag.IBTS,year.IBTS)) # mostly binary until 2010, 2011
bag.IBTS.bin = ifelse(bag.IBTS>0, 1, 0)

human.IBTS.bin = bag.IBTS.bin + caps.IBTS.bin + sheet.IBTS.bin + bottles.plas.IBTS.bin
human.IBTS.bin = ifelse(human.IBTS.bin >= 0.5, 1, 0)

# fishing-related plastic

fishline.mono.IBTS = fishline.mono[survey=='IBTS']
table(list(fishline.mono.IBTS,year.IBTS)) # mostly binary until 2010, 2011
fishline.mono.IBTS.bin = ifelse(fishline.mono.IBTS>0, 1, 0)

fishline.tang.IBTS = fishline.tang[survey=='IBTS']
table(list(fishline.tang.IBTS,year.IBTS)) # mostly binary until 2010, 2011
fishline.tang.IBTS.bin = ifelse(fishline.tang.IBTS>0, 1, 0)

synthrope.IBTS = synthrope[survey=='IBTS']
table(list(synthrope.IBTS,year.IBTS)) # mostly binary until 2010, 2011
synthrope.IBTS.bin = ifelse(synthrope.IBTS>0, 1, 0)

fishnet.IBTS = fishnet[survey=='IBTS']
table(list(fishnet.IBTS,year.IBTS)) # mostly binary until 2010, 2011
fishnet.IBTS.bin = ifelse(fishnet.IBTS>0, 1, 0)

cabletie.IBTS = cabletie[survey=='IBTS']
table(list(cabletie.IBTS,year.IBTS)) # mostly binary until 2010, 2011
cabletie.IBTS.bin = ifelse(cabletie.IBTS>0, 1, 0)

strap.IBTS = strap[survey=='IBTS']
table(list(strap.IBTS,year.IBTS)) # mostly binary until 2010, 2011
strap.IBTS.bin = ifelse(strap.IBTS>0, 1, 0)

crates.IBTS = crates[survey=='IBTS']
table(list(crates.IBTS,year.IBTS)) # mostly binary until 2010, 2011
crates.IBTS.bin = ifelse(crates.IBTS>0, 1, 0)

fishline.IBTS.bin = fishline.mono.IBTS.bin  + fishline.tang.IBTS.bin

fishing.IBTS.bin = fishline.IBTS.bin + synthrope.IBTS.bin + fishnet.IBTS.bin + cabletie.IBTS.bin + strap.IBTS.bin + crates.IBTS.bin
fishing.IBTS.bin = ifelse(fishing.IBTS.bin >= 0.5, 1, 0)

par(mfrow=c(4,3),mar=c(3,3,3,1.5))

human.perc = tapply(human.IBTS.bin, year.IBTS, mean)*100
temp = mannkendall.rand(year.plot, human.perc)
plot(year.plot, human.perc, xlab=' ', ylab=' ', type='b', main=paste('Human (p=',round(temp$p,2),')'))

bottles.perc = tapply(bottles.plas.IBTS.bin, year.IBTS, mean)*100
temp = mannkendall.rand(year.plot, bottles.perc)
plot(year.plot, bottles.perc, xlab=' ', type='b', main=paste('Bottles (p=',round(temp$p,2),')'))

sheet.perc = tapply(sheet.IBTS.bin, year.IBTS, mean)*100
temp = mannkendall.rand(year.plot, sheet.perc)
plot(year.plot, sheet.perc, xlab=' ', ylab=' ', type='b', main=paste('Sheet (p=',round(temp$p,2),')'))

bag.perc = tapply(bag.IBTS.bin, year.IBTS, mean)*100
temp = mannkendall.rand(year.plot, bag.perc)
plot(year.plot, bag.perc, xlab=' ', ylab=' ', type='b', main=paste('Bags (p=',round(temp$p,2),')'))

caps.perc = tapply(caps.IBTS.bin, year.IBTS, mean)*100
temp = mannkendall.rand(year.plot, caps.perc)
plot(year.plot, caps.perc, xlab=' ', ylab=' ', type='b', main=paste('Caps (p=',round(temp$p,2),')'))

fishing.perc = tapply(fishing.IBTS.bin, year.IBTS, mean)*100
temp = mannkendall.rand(year.plot, fishing.perc)
plot(year.plot, fishing.perc, xlab=' ', ylab=' ', type='b', main=paste('Fishing (p=',round(temp$p,2),')'))

synthrope.perc = tapply(synthrope.IBTS.bin, year.IBTS, mean)*100
temp = mannkendall.rand(year.plot, synthrope.perc)
plot(year.plot, synthrope.perc, xlab=' ', ylab=' ', type='b', main=paste('Rope (p=',round(temp$p,2),')'))

fishnet.perc = tapply(fishnet.IBTS.bin, year.IBTS, mean)*100
temp = mannkendall.rand(year.plot, fishnet.perc)
plot(year.plot, fishnet.perc, xlab=' ', ylab=' ', type='b', main=paste('Fishnets (p=',round(temp$p,2),')'))

cabletie.perc = tapply(cabletie.IBTS.bin, year.IBTS, mean)*100
temp = mannkendall.rand(year.plot, cabletie.perc)
plot(year.plot, cabletie.perc, xlab=' ', ylab=' ', type='b', main=paste('Cableties (p=',round(temp$p,2),')'))

strap.perc = tapply(strap.IBTS.bin, year.IBTS, mean)*100
temp = mannkendall.rand(year.plot, strap.perc)
plot(year.plot, strap.perc, xlab=' ', ylab=' ', type='b', main=paste('Strap (p=',round(temp$p,2),')'))

crates.perc = tapply(crates.IBTS.bin, year.IBTS, mean)*100
temp = mannkendall.rand(year.plot, crates.perc)
plot(year.plot, crates.perc, xlab=' ', ylab=' ', type='b', main=paste('Crates (p=',round(temp$p,2),')'))

fishline.perc = tapply(fishline.IBTS.bin, year.IBTS, mean)*100
temp = mannkendall.rand(year.plot, fishline.perc)
plot(year.plot, fishline.perc, xlab=' ', ylab=' ', type='b', main=paste('Fishline (p=',round(temp$p,2),')'))

#
# Concentrate on plastic bags
#
bag.IBTS = bag[survey=='IBTS']
table(list(bag.IBTS,year.IBTS)) # mostly binary until 2010, 2011
bag.IBTS.bin = ifelse(bag.IBTS>0, 1, 0)
year.IBTS = year[survey=='IBTS']
area.IBTS = area[survey=='IBTS']

# How much are the areas changing?
tapply(area.IBTS, year.IBTS, mean)

par(mfrow=c(1,1), mar=c(4,4,4,4))
bags.perc = tapply(bag.IBTS.bin, year.IBTS, mean)*100
plot(year.plot, bags.perc, xlab='Year', ylab='Percentage trawls with bags', type='b')
title('Percentage of IBTS trawls containing plastic bags')

bag.IBTS.bin.2009 = bag.IBTS.bin[year.IBTS >=2009]
bag.IBTS.bin.pre2009 = bag.IBTS.bin[year.IBTS < 2009]

bag.IBTS.bin.2010 = bag.IBTS.bin[year.IBTS >=2010]
bag.IBTS.bin.pre2010 = bag.IBTS.bin[year.IBTS < 2010]

permute = function(v1, v2, nreps=10000) {
#**********************************************************
# One-sided andomisation test (v1 should be bigger than v2)
#**********************************************************
obs.diff = mean(v1) - mean(v2)
v12 = c(v1,v2)
l12 = length(v12)
l1 = length(v1) 
sim.diff = rep(0,nreps)
for (j in 1:nreps) {
perm = sample(v12)
sim.diff[j] = mean(perm[1:l1]) - mean(perm[(l1+1):l12])
}
bigger = sim.diff[sim.diff >= obs.diff]
pvalue = length(bigger)/nreps
pvalue
}

mean(bag.IBTS.bin.pre2009); mean(bag.IBTS.bin.2009)
mean(bag.IBTS.bin.pre2010); mean(bag.IBTS.bin.2010)

permute(bag.IBTS.bin.pre2009, bag.IBTS.bin.2009)
permute(bag.IBTS.bin.pre2010, bag.IBTS.bin.2010)

#*********************************************************************
# LOOK AT TEMPORAL EFFECTS FOR JUST THE CSEMP SURVEYS
#*********************************************************************

par(mfrow=c(4,3), mar=c(1,1,1,1))
for (j in c(2000:2008, 2010, 2011)) {
plot(long[year==j & survey=='CSEMP'], lat[year==j & survey=='CSEMP'], xlim = c(minlong, maxlong), ylim = c(minlat, maxlat))
text(-7, 61, as.character(j))
}

par(mfrow=c(1,1))
k=0
for (j in c(2000:2008, 2010, 2011)) {
k = k+1
if (k==1) plot(long[year==j & survey=='CSEMP'], lat[year==j & survey=='CSEMP'], xlim = c(minlong, maxlong), ylim = c(minlat, maxlat))
points(long[year==j & survey=='CSEMP'], lat[year==j & survey=='CSEMP'], pch=k, col=k)
}

year.plot = c(2000:2008, 2010, 2011)
all.mean = tapply(litter.km2[survey=='CSEMP'], year[survey=='CSEMP'], mean)
plas.mean = tapply(litter.km2.plas[survey=='CSEMP'], year[survey=='CSEMP'], mean)
san.mean = tapply(litter.km2.san[survey=='CSEMP'], year[survey=='CSEMP'], mean)
met.mean = tapply(litter.km2.met[survey=='CSEMP'], year[survey=='CSEMP'], mean)
rub.mean = tapply(litter.km2.rub[survey=='CSEMP'], year[survey=='CSEMP'], mean)
glass.mean = tapply(litter.km2.glass[survey=='CSEMP'], year[survey=='CSEMP'], mean)
nat.mean = tapply(litter.km2.nat[survey=='CSEMP'], year[survey=='CSEMP'], mean)
misc.mean = tapply(litter.km2.misc[survey=='CSEMP'], year[survey=='CSEMP'], mean)

par(mfrow=c(3,3),mar=c(4,3,3,1.5))
plot(year.plot, all.mean, xlab=' ', type='b', main='Total (p=0.83)')
s = ksmooth(year.plot, all.mean, bandwidth=2, kernel=c("normal"), n.points=100)
#lines(s$x, s$y)

plot(year.plot, plas.mean, xlab=' ', type='b', main='Plastic (p=0.82)')
s = ksmooth(year.plot, plas.mean, bandwidth=2, kernel=c("normal"), n.points=100)
#lines(s$x, s$y)

plot(year.plot, san.mean, type='b', xlab=' ', main='Sanitary')
s = ksmooth(year.plot, san.mean, bandwidth=2, kernel=c("normal"), n.points=100)
#lines(s$x, s$y)

plot(year.plot, met.mean, type='b', xlab=' ', main='Metal (p=0.50)')
s = ksmooth(year.plot, met.mean, bandwidth=2, kernel=c("normal"), n.points=100)
#lines(s$x, s$y)

plot(year.plot, rub.mean, type='b', xlab=' ', main='Rubber (p=0.70)')
s = ksmooth(year.plot, rub.mean, bandwidth=2, kernel=c("normal"), n.points=100)
#lines(s$x, s$y)

plot(year.plot, glass.mean, type='b', xlab=' ', main='Glass (p=0.88)')
s = ksmooth(year.plot, glass.mean, bandwidth=2, kernel=c("normal"), n.points=100)
#lines(s$x, s$y)

plot(year.plot, nat.mean, type='b', xlab=' ', main='Natural (p=0.69)')
s = ksmooth(year.plot, nat.mean, bandwidth=2, kernel=c("normal"), n.points=100)
#lines(s$x, s$y)

plot(year.plot, misc.mean, type='b', xlab=' ', main='Misc (p=0.18)')
s = ksmooth(year.plot, misc.mean, bandwidth=2, kernel=c("normal"), n.points=100)
#lines(s$x, s$y)

# Calculate Mann-Kendall for each of these time series

mannkendall.rand(year.plot, all.mean)
mannkendall.rand(year.plot, plas.mean)
mannkendall.rand(year.plot, san.mean)
mannkendall.rand(year.plot, met.mean)
mannkendall.rand(year.plot, rub.mean)
mannkendall.rand(year.plot, glass.mean)
mannkendall.rand(year.plot, nat.mean)
mannkendall.rand(year.plot, misc.mean)

# ***************************************************************************
#****************************************************************************
#****************************************************************************
# Look at power for detecting trends.
# They want to know how many observations to take to be able to
# detect 10 / 50% changes over 1, 5 and 10 years.
# For a single year just use a t-test or a randomisation test.
# For 5 or 10 years, assume a linear trend.
# Might be good to do this work for the two time series separately.
# ie CSEMP and IBTS 
# 

trend.power=function(diffpct, reps, npower, nyears ) {
#*****************************************************************************************
# reps = replicates per sampling occasion
# init = initial value
# npower = number of simulations
# sigma = standard deviation
# diffpct = % change want to detect
# nyears = number of study years
#*****************************************************************************************
init = 8.28
sigma = 1.39
final = init + (diffpct/100)*init
slope = abs(final - init)/(nyears-1)
years = rep(c(1:(nyears-1)),rep(reps,(nyears-1)))
n = reps*(nyears-1)
count = 0
for (k in 1:npower) {
y = init - slope*years + rnorm(n,0,sigma)
dev0 = deviance(lm(y ~ (1)))
dev1 = deviance(lm(y ~ years))
f = (dev0 - dev1)*(n-2)/dev1
p = 1 - pf(f,1,n-2)
if (p<0.05) count=count+1 else count=count+0
}
power = count/npower
power }



trend.power.nbinom=function(diffpct, init, k, mu, nsamples, npower, nyears, nreps) {
#*****************************************************************************************
# USE MANN-KENDALL TO DETECT CHANGE
# Baseline year is assumed to be 2011
# nsamples = samples per year
# init = initial value
# npower = number of simulations
# k = negative binomial size parameter (stays constant)
# mu = negative binomial mean (this is increased)
# diffpct = % change want to detect
# nyears = number of study years (but should generate n+1 years of data)
# nreps = no of reps to calculate p-value for Mann-Kendall
#*****************************************************************************************
#init = mu.IBTS
#k = k.IBTS
#diffpct = 50
#nyears = 5
#mu = mu.IBTS
#nsamples = 50
#npower = 10

mu.final = mu + (diffpct/100)*mu
mu.change = (mu.final - mu) / nyears

count = 0
for (k in 1:npower) {
year.stack = 888888
litter.stack = 888888
for (j in 1:(nyears+1)) {
year.now = 2011 + j - 1
mu.now = mu + (mu.change * (j-1))
litter.new =  rnbinom(nsamples, size=k, mu=mu.now) * sample(area.tot.IBTS.1011, nsamples, replace=T)
year.new = rep(year.now, nsamples)
year.stack = c(year.stack, year.new)
litter.stack = c(litter.stack, litter.new)
}
litter.stack = litter.stack[-1]
year.stack = year.stack[-1]
#
litter.stack.means = tapply(litter.stack, year.stack, mean)
year.stack.means = 2011:(2011+nyears)
#p1 = mannkendall.rand(year.stack, litter.stack, nreps=nreps)$p
p2 = mannkendall.rand(year.stack.means, litter.stack.means, nreps=nreps)$p
if (p2 < 0.05) count = count + 1
}
power = count / npower
power
}

#
# Look at PLASTICS for CSEMP only
#

year.plot = c(2000:2008, 2010, 2011)

par(mfrow=c(4,3),mar=c(3,3,3,1.5))

human.mean = tapply(litter.km2.human.plas[survey=='CSEMP'], year[survey=='CSEMP'], mean)
temp = mannkendall.rand(year.plot, human.mean)
plot(year.plot, human.mean, xlab=' ', type='b', main=paste('Human (p=',round(temp$p,2),')'))

bottles.mean = tapply(litter.km2.bottles.plas[survey=='CSEMP'], year[survey=='CSEMP'], mean)
temp = mannkendall.rand(year.plot, bottles.mean)
plot(year.plot, bottles.mean, xlab=' ', type='b', main=paste('Bottles (p=',round(temp$p,2),')'))

sheet.mean = tapply(litter.km2.sheet.plas[survey=='CSEMP'], year[survey=='CSEMP'], mean)
temp = mannkendall.rand(year.plot, sheet.mean)
plot(year.plot, sheet.mean, xlab=' ', type='b', main=paste('Sheet (p=',round(temp$p,2),')'))

bag.mean = tapply(litter.km2.bag.plas[survey=='CSEMP'], year[survey=='CSEMP'], mean)
temp = mannkendall.rand(year.plot, bag.mean)
plot(year.plot, bag.mean, xlab=' ', type='b', main=paste('Bags (p=',round(temp$p,2),')'))

caps.mean = tapply(litter.km2.caps.plas[survey=='CSEMP'], year[survey=='CSEMP'], mean)
temp = mannkendall.rand(year.plot, caps.mean)
plot(year.plot, caps.mean, xlab=' ', type='b', main=paste('Caps (p=',round(temp$p,2),')'))

fishing.mean = tapply(litter.km2.fishing.plas[survey=='CSEMP'], year[survey=='CSEMP'], mean)
temp = mannkendall.rand(year.plot, fishing.mean)
plot(year.plot, fishing.mean, xlab=' ', type='b', main=paste('Fishing (p=',round(temp$p,2),')'))

synthrope.mean = tapply(litter.km2.synthrope.plas[survey=='CSEMP'], year[survey=='CSEMP'], mean)
temp = mannkendall.rand(year.plot, synthrope.mean)
plot(year.plot, synthrope.mean, xlab=' ', type='b', main=paste('Rope (p=',round(temp$p,2),')'))

fishnet.mean = tapply(litter.km2.fishnet.plas[survey=='CSEMP'], year[survey=='CSEMP'], mean)
temp = mannkendall.rand(year.plot, fishnet.mean)
plot(year.plot, fishnet.mean, xlab=' ', type='b', main=paste('Nets (p=',round(temp$p,2),')'))

cabletie.mean = tapply(litter.km2.cabletie.plas[survey=='CSEMP'], year[survey=='CSEMP'], mean)
temp = mannkendall.rand(year.plot, cabletie.mean)
plot(year.plot, cabletie.mean, xlab=' ', type='b', main=paste('Cableties (p=',round(temp$p,2),')'))

strap.mean = tapply(litter.km2.strap.plas[survey=='CSEMP'], year[survey=='CSEMP'], mean)
temp = mannkendall.rand(year.plot, strap.mean)
plot(year.plot, strap.mean, xlab=' ', type='b', main=paste('Straps (p=',round(temp$p,2),')'))

crates.mean = tapply(litter.km2.crates.plas[survey=='CSEMP'], year[survey=='CSEMP'], mean)
temp = mannkendall.rand(year.plot, crates.mean)
plot(year.plot, crates.mean, xlab=' ', type='b', main=paste('Crates (p=',round(temp$p,2),')'))

line.mean = tapply(litter.km2.line.plas[survey=='CSEMP'], year[survey=='CSEMP'], mean)
temp = mannkendall.rand(year.plot, line.mean)
plot(year.plot, line.mean, xlab=' ', type='b', main=paste('Fishline (p=',round(temp$p,2),')'))


#
# Concentrate on plastic bags
#
bag.CSEMP = bag[survey=='CSEMP']
year.CSEMP = year[survey=='CSEMP']
area.CSEMP = area[survey=='CSEMP']

par(mfrow=c(1,1), mar=c(4,4,4,4))
bags.mean = tapply(bag.CSEMP, year.CSEMP, mean)
plot(year.plot, bags.mean, xlab='Year', ylab='Mean bags per trawl', type='b')
title('Mean plastic bags per trawl for CSEMP surveys')

bag.CSEMP.2010 = bag.CSEMP[year.CSEMP >=2010]
bag.CSEMP.pre2010 = bag.CSEMP[year.CSEMP < 2010]

mean(bag.CSEMP.pre2010)
mean(bag.CSEMP.2010)

permute(bag.CSEMP.pre2010, bag.CSEMP.2010) # p=0.056

#
# I'm assuming that the counts of litter have a negative binomial
# distribution. I estimate the mean and k from this distribution and then
# bump up the mean for when looking at % increases. I take a random sample
# from the empirical distribution of trawl distances.
#


loglik.nb = function(k,mu,x) {
#*************************************************************************
# -2log(likelihood) function assuming x come from negative binomial distn.
#*************************************************************************
loglik = 0
lik = prod(dnbinom(x, size=k, mu=mu))
loglik = log(lik)
-2*loglik
}


# TESTING ESTIMATION OF NB PARAMETERS
# mu is estimated from the segment mean. k is estimated by maximum likelihood
# using the optimize function. The code below does it 1000 times.

khat = rep(0,1000)
for (j in 1:1000) {
data = rnbinom(20, size=1, mu=7)
muhat = mean(data)
sol = optimize(f=loglik.nb, mu=muhat, x=data, interval=c(0,100))
khat[j] = sol$min
}

#
# We need to decide which surveys to use to represent the Greater North Sea
# and the Celtic Seas
#
#*************************************************************************
library(maps)
library(mapdata)
library(mapproj)
survey.name = c('CSEMP', 'DBTS', 'IBTS', 'MEM', 'NWGFS', 'Q1SW', 'Q1SWB', 'Q4SW')
par(mfrow=c(1,1),mar=c(3,3,1,1))
plot(long[year==2011 & survey==survey.name[1]], lat[year==2011 & survey==survey.name[1]], xlim = c(minlong, maxlong), ylim = c(minlat, maxlat), col=1, pch=1, xlab=' ', ylab=' ')
for (j in 2:8) {
points(long[year==2011 & survey==survey.name[j]], lat[year==2011 & survey==survey.name[j]], col=j, pch=j)
}
map('worldHires', col="olivedrab", fill=T, add=T)
legend('topleft', legend=survey.name, col=1:8, pch=1:8)
#**************************************************************************

table(year, survey)
table(survey,gear)
#
# Want to use the NWGFS (beam) and Q4SW (otter) to represent
# the Celtic Seas.
# And IBTS (otter) and DBTS (beam) to represent the Greater North Sea.
# But they use different trawling methods. For now, use IBTS and Q4SW only
# (these actually use the same trawling methods). 
#
tapply(litter.tot[year==2010 | year==2011], survey[year==2010 | year==2011], mean)
tapply(litter.tot[year==2010 | year==2011], survey[year==2010 | year==2011], sd)

tapply(litter.km2[year==2010 | year==2011], survey[year==2010 | year==2011], mean)
tapply(litter.km2[year==2010 | year==2011], survey[year==2010 | year==2011], sd)

tapply(litter.km2[survey=='IBTS'], year[survey=='IBTS'], length)
tapply(litter.km2[survey=='IBTS'], year[survey=='IBTS'], sd)
tapply(litter.km2[survey=='IBTS'], year[survey=='IBTS'], mean)

litter.tot.IBTS.1011 = litter.tot[survey=='IBTS' & (year==2010 | year==2011)]
area.tot.IBTS.1011 = area[survey=='IBTS' & (year==2010 | year==2011)]
area.tot.IBTS.1011 = area.tot.IBTS.1011[area.tot.IBTS.1011 != 999]
hist(litter.tot.IBTS.1011, breaks = c(0:22), main='IBTS litter items per trawl in 2010 and 2011', xlab='Number of litter items')
arse = hist(litter.tot.IBTS.1011, breaks = c(0:22), main='IBTS litter items per trawl in 2010 and 2011', xlab='Number of litter items')
lines(arse$mids, est.dens, col='red')
#
# Estimate negative binomial parameters for baseline year for IBTS
#
mu.IBTS = mean(litter.tot.IBTS.1011)
k.IBTS = optimize(f=loglik.nb, mu=mu.IBTS, x=litter.tot.IBTS.1011, interval=c(0,100))$min
mu.IBTS; k.IBTS
#
# See how estimated density compares to observed density
#
est.dens = dnbinom(0:22, size=k.IBTS, mu=mu.IBTS)*length(litter.tot.IBTS.1011)
hist(litter.tot.IBTS.1011, breaks = seq(-0.5, 22.5, 1), main='IBTS litter items per trawl in 2010 and 2011', xlab='Number of litter items')
lines(0:22, est.dens, col='red')
#
# Need to run these power calculations for 10% change and also for
# 10 year trend. But make sure I've got the area correct first.
#

diffs = seq(40,100,10) # needs to be in 5 differences
power.IBTS.5.50 = rep(0,length(diffs))
power.IBTS.5.40 = rep(0,length(diffs))
power.IBTS.5.30 = rep(0,length(diffs))
power.IBTS.5.20 = rep(0,length(diffs))
power.IBTS.5.10 = rep(0,length(diffs))
power.IBTS.10.50 = rep(0,length(diffs))
power.IBTS.10.40 = rep(0,length(diffs))
power.IBTS.10.30 = rep(0,length(diffs))
power.IBTS.10.20 = rep(0,length(diffs))
power.IBTS.10.10 = rep(0,length(diffs))
m=0
for (j in diffs) {
m = m + 1
power.IBTS.5.50[m] = trend.power.nbinom(diffpct=50, init=mu.IBTS, k=k.IBTS, mu=mu.IBTS, nsamples=j, npower=100, nyears=5, nreps=100)
power.IBTS.5.40[m] = trend.power.nbinom(diffpct=40, init=mu.IBTS, k=k.IBTS, mu=mu.IBTS, nsamples=j, npower=100, nyears=5, nreps=100)
power.IBTS.5.30[m] = trend.power.nbinom(diffpct=30, init=mu.IBTS, k=k.IBTS, mu=mu.IBTS, nsamples=j, npower=100, nyears=5, nreps=100)
power.IBTS.5.20[m] = trend.power.nbinom(diffpct=20, init=mu.IBTS, k=k.IBTS, mu=mu.IBTS, nsamples=j, npower=100, nyears=5, nreps=100)
power.IBTS.5.10[m] = trend.power.nbinom(diffpct=10, init=mu.IBTS, k=k.IBTS, mu=mu.IBTS, nsamples=j, npower=100, nyears=5, nreps=100)
power.IBTS.10.50[m] = trend.power.nbinom(diffpct=50, init=mu.IBTS, k=k.IBTS, mu=mu.IBTS, nsamples=j, npower=100, nyears=10, nreps=100)
power.IBTS.10.40[m] = trend.power.nbinom(diffpct=40, init=mu.IBTS, k=k.IBTS, mu=mu.IBTS, nsamples=j, npower=100, nyears=10, nreps=100)
power.IBTS.10.30[m] = trend.power.nbinom(diffpct=30, init=mu.IBTS, k=k.IBTS, mu=mu.IBTS, nsamples=j, npower=100, nyears=10, nreps=100)
power.IBTS.10.20[m] = trend.power.nbinom(diffpct=20, init=mu.IBTS, k=k.IBTS, mu=mu.IBTS, nsamples=j, npower=100, nyears=10, nreps=100)
power.IBTS.10.10[m] = trend.power.nbinom(diffpct=10, init=mu.IBTS, k=k.IBTS, mu=mu.IBTS, nsamples=j, npower=100, nyears=10, nreps=100)
}

# Do one plot for 5 year trend and one plot for 10 year trend

# 5 YEAR TREND
par(mfrow=c(1,1), mar=c(4.5,4,3,3))
plot(diffs, power.IBTS.5.50, ylim=c(0,1), xlab='Sample size', ylab='Power', type='b', col=1, pch=1)
lines(diffs, power.IBTS.5.40, type='b', col=2, lty=2, pch=2)
lines(diffs, power.IBTS.5.30, type='b', col=3, lty=3, pch=3)
lines(diffs, power.IBTS.5.20, type='b', col=4, lty=4, pch=4)
lines(diffs, power.IBTS.5.10, type='b', col=5, lty=5, pch=5)
abline(h=0.8, lty=2)
title('Power for 5 year trend (IBTS)')
legend('topleft', legend=c('50%', '40%', '30%', '20%', '10%'), col=c(1,2,3,4,5), lty=c(1,2,3,4,5), pch=c(1,2,3,4,5))

# 10 YEAR TREND
par(mfrow=c(1,1), mar=c(4.5,4,3,3))
plot(diffs, power.IBTS.10.50, ylim=c(0,1), xlab='Sample size', ylab='Power', type='b', col=1, pch=1)
lines(diffs, power.IBTS.10.40, type='b', col=2, lty=2, pch=2)
lines(diffs, power.IBTS.10.30, type='b', col=3, lty=3, pch=3)
lines(diffs, power.IBTS.10.20, type='b', col=4, lty=4, pch=4)
lines(diffs, power.IBTS.10.10, type='b', col=5, lty=5, pch=5)
abline(h=0.8, lty=2)
title('Power for 10 year trend (IBTS)')
legend('bottomright', legend=c('50%', '40%', '30%', '20%', '10%'), col=c(1,2,3,4,5), lty=c(1,2,3,4,5), pch=c(1,2,3,4,5))

#
# Find power for the sample size used in 2011 for IBTS (nsamples=88)
#table(year,survey)
#nsamples.2011 = 88
#power.IBTS.5.50.2011 = trend.power.nbinom(diffpct=50, init=mu.IBTS, k=k.IBTS, mu=mu.IBTS, nsamples=nsamples.2011, npower=500, nyears=5, nreps=200)
#power.IBTS.5.10.2011 = trend.power.nbinom(diffpct=10, init=mu.IBTS, k=k.IBTS, mu=mu.IBTS, nsamples=nsamples.2011, npower=500, nyears=5, nreps=200)
#power.IBTS.10.50.2011 = trend.power.nbinom(diffpct=50, init=mu.IBTS, k=k.IBTS, mu=mu.IBTS, nsamples=nsamples.2011, npower=500, nyears=10, nreps=200)
#power.IBTS.10.10.2011 = trend.power.nbinom(diffpct=10, init=mu.IBTS, k=k.IBTS, mu=mu.IBTS, nsamples=nsamples.2011, npower=500, nyears=10, nreps=200)

# Also do it for total North Sea sample size
nsamples.2011 = 186
power.IBTS.5.50.2011 = trend.power.nbinom(diffpct=50, init=mu.IBTS, k=k.IBTS, mu=mu.IBTS, nsamples=nsamples.2011, npower=500, nyears=5, nreps=200)
power.IBTS.5.40.2011 = trend.power.nbinom(diffpct=40, init=mu.IBTS, k=k.IBTS, mu=mu.IBTS, nsamples=nsamples.2011, npower=500, nyears=5, nreps=200)
power.IBTS.5.30.2011 = trend.power.nbinom(diffpct=30, init=mu.IBTS, k=k.IBTS, mu=mu.IBTS, nsamples=nsamples.2011, npower=500, nyears=5, nreps=200)
power.IBTS.5.20.2011 = trend.power.nbinom(diffpct=20, init=mu.IBTS, k=k.IBTS, mu=mu.IBTS, nsamples=nsamples.2011, npower=500, nyears=5, nreps=200)
power.IBTS.5.10.2011 = trend.power.nbinom(diffpct=10, init=mu.IBTS, k=k.IBTS, mu=mu.IBTS, nsamples=nsamples.2011, npower=500, nyears=5, nreps=200)
power.IBTS.10.50.2011 = trend.power.nbinom(diffpct=50, init=mu.IBTS, k=k.IBTS, mu=mu.IBTS, nsamples=nsamples.2011, npower=500, nyears=10, nreps=200)
power.IBTS.10.40.2011 = trend.power.nbinom(diffpct=40, init=mu.IBTS, k=k.IBTS, mu=mu.IBTS, nsamples=nsamples.2011, npower=500, nyears=10, nreps=200)
power.IBTS.10.30.2011 = trend.power.nbinom(diffpct=30, init=mu.IBTS, k=k.IBTS, mu=mu.IBTS, nsamples=nsamples.2011, npower=500, nyears=10, nreps=200)
power.IBTS.10.20.2011 = trend.power.nbinom(diffpct=20, init=mu.IBTS, k=k.IBTS, mu=mu.IBTS, nsamples=nsamples.2011, npower=500, nyears=10, nreps=200)
power.IBTS.10.10.2011 = trend.power.nbinom(diffpct=10, init=mu.IBTS, k=k.IBTS, mu=mu.IBTS, nsamples=nsamples.2011, npower=500, nyears=10, nreps=200)


# *************************************************************************
# Repeat power stuff for Q4SW survey
#**************************************************************************
table(year, survey)
table(survey,gear)
#
tapply(litter.km2[survey=='Q4SW'], year[survey=='Q4SW'], length)
tapply(litter.km2[survey=='Q4SW'], year[survey=='Q4SW'], sd)
tapply(litter.km2[survey=='Q4SW'], year[survey=='Q4SW'], mean)

litter.tot.Q4SW.1011 = litter.tot[survey=='Q4SW' & (year==2010 | year==2011)]
area.tot.Q4SW.1011 = area[survey=='Q4SW' & (year==2010 | year==2011)]
area.tot.Q4SW.1011 = area.tot.Q4SW.1011[area.tot.Q4SW.1011 != 999]
#
# Estimate negative binomial parameters for baseline year for Q4SW
#
mu.Q4SW = mean(litter.tot.Q4SW.1011)
k.Q4SW = optimize(f=loglik.nb, mu=mu.Q4SW, x=litter.tot.Q4SW.1011, interval=c(0,100))$min
mu.Q4SW; k.Q4SW
#
# See how estimated density compares to observed density
#
est.dens = dnbinom(0:8, size=k.Q4SW, mu=mu.Q4SW)*length(litter.tot.Q4SW.1011)
hist(litter.tot.Q4SW.1011, breaks = seq(-0.5, 8.5, 1), main='Q4SW litter items per trawl in 2010 and 2011', xlab='Number of litter items')
lines(0:8, est.dens, col='red')
#
# Need to run these power calculations for 10% change and also for
# 10 year trend. But make sure I've got the area correct first.
#

diffs = seq(40,100,10) # needs to be in 5 differences
power.Q4SW.5.50 = rep(0,length(diffs))
power.Q4SW.5.40 = rep(0,length(diffs))
power.Q4SW.5.30 = rep(0,length(diffs))
power.Q4SW.5.20 = rep(0,length(diffs))
power.Q4SW.5.10 = rep(0,length(diffs))
power.Q4SW.10.50 = rep(0,length(diffs))
power.Q4SW.10.40 = rep(0,length(diffs))
power.Q4SW.10.30 = rep(0,length(diffs))
power.Q4SW.10.20 = rep(0,length(diffs))
power.Q4SW.10.10 = rep(0,length(diffs))
m=0
for (j in diffs) {
m = m + 1
#power.Q4SW.5.50[m] = trend.power.nbinom(diffpct=50, init=mu.Q4SW, k=k.Q4SW, mu=mu.Q4SW, nsamples=j, npower=100, nyears=5, nreps=100)
power.Q4SW.5.40[m] = trend.power.nbinom(diffpct=40, init=mu.Q4SW, k=k.Q4SW, mu=mu.Q4SW, nsamples=j, npower=100, nyears=5, nreps=100)
power.Q4SW.5.30[m] = trend.power.nbinom(diffpct=30, init=mu.Q4SW, k=k.Q4SW, mu=mu.Q4SW, nsamples=j, npower=100, nyears=5, nreps=100)
power.Q4SW.5.20[m] = trend.power.nbinom(diffpct=20, init=mu.Q4SW, k=k.Q4SW, mu=mu.Q4SW, nsamples=j, npower=100, nyears=5, nreps=100)
power.Q4SW.5.10[m] = trend.power.nbinom(diffpct=10, init=mu.Q4SW, k=k.Q4SW, mu=mu.Q4SW, nsamples=j, npower=100, nyears=5, nreps=100)
#power.Q4SW.10.50[m] = trend.power.nbinom(diffpct=50, init=mu.Q4SW, k=k.Q4SW, mu=mu.Q4SW, nsamples=j, npower=100, nyears=10, nreps=100)
#power.Q4SW.10.40[m] = trend.power.nbinom(diffpct=40, init=mu.Q4SW, k=k.Q4SW, mu=mu.Q4SW, nsamples=j, npower=100, nyears=10, nreps=100)
#power.Q4SW.10.30[m] = trend.power.nbinom(diffpct=30, init=mu.Q4SW, k=k.Q4SW, mu=mu.Q4SW, nsamples=j, npower=100, nyears=10, nreps=100)
#power.Q4SW.10.20[m] = trend.power.nbinom(diffpct=20, init=mu.Q4SW, k=k.Q4SW, mu=mu.Q4SW, nsamples=j, npower=100, nyears=10, nreps=100)
#power.Q4SW.10.10[m] = trend.power.nbinom(diffpct=10, init=mu.Q4SW, k=k.Q4SW, mu=mu.Q4SW, nsamples=j, npower=100, nyears=10, nreps=100)
}

# PLOTS FOR 5 YEAR TREND

par(mfrow=c(1,1), mar=c(4.5,4,3,3))
plot(diffs, power.Q4SW.5.50, ylim=c(0,1), xlab='Sample size', ylab='Power', type='b', col=1, pch=1)
lines(diffs, power.Q4SW.5.40, type='b', col=2, lty=2, pch=2)
lines(diffs, power.Q4SW.5.30, type='b', col=3, lty=3, pch=3)
lines(diffs, power.Q4SW.5.20, type='b', col=4, lty=4, pch=4)
lines(diffs, power.Q4SW.5.10, type='b', col=5, lty=5, pch=5)
abline(h=0.8, lty=2)
title('Power for 5 year trend (Q4SW)')
legend('bottomright', legend=c('50%', '40%', '30%', '20%', '10%'), col=c(1,2,3,4,5), lty=c(1,2,3,4,5), pch=c(1,2,3,4,5))

# 10 YEAR TREND
par(mfrow=c(1,1), mar=c(4.5,4,3,3))
plot(diffs, power.Q4SW.10.50, ylim=c(0,1), xlab='Sample size', ylab='Power', type='b', col=1, pch=1)
lines(diffs, power.Q4SW.10.40, type='b', col=2, lty=2, pch=2)
lines(diffs, power.Q4SW.10.30, type='b', col=3, lty=3, pch=3)
lines(diffs, power.Q4SW.10.20, type='b', col=4, lty=4, pch=4)
lines(diffs, power.Q4SW.10.10, type='b', col=5, lty=5, pch=5)
abline(h=0.8, lty=2)
title('Power for 10 year trend (Q4SW)')
legend('bottomright', legend=c('50%', '40%', '30%', '20%', '10%'), col=c(1,2,3,4,5), lty=c(1,2,3,4,5), pch=c(1,2,3,4,5))

# Also do it for total Celtic Seas sample size
nsamples.2011 = 454
power.Q4SW.5.50.2011 = trend.power.nbinom(diffpct=50, init=mu.Q4SW, k=k.Q4SW, mu=mu.Q4SW, nsamples=nsamples.2011, npower=500, nyears=5, nreps=200)
power.Q4SW.5.40.2011 = trend.power.nbinom(diffpct=40, init=mu.Q4SW, k=k.Q4SW, mu=mu.Q4SW, nsamples=nsamples.2011, npower=500, nyears=5, nreps=200)
power.Q4SW.5.30.2011 = trend.power.nbinom(diffpct=30, init=mu.Q4SW, k=k.Q4SW, mu=mu.Q4SW, nsamples=nsamples.2011, npower=500, nyears=5, nreps=200)
power.Q4SW.5.20.2011 = trend.power.nbinom(diffpct=20, init=mu.Q4SW, k=k.Q4SW, mu=mu.Q4SW, nsamples=nsamples.2011, npower=500, nyears=5, nreps=200)
power.Q4SW.5.10.2011 = trend.power.nbinom(diffpct=10, init=mu.Q4SW, k=k.Q4SW, mu=mu.Q4SW, nsamples=nsamples.2011, npower=500, nyears=5, nreps=200)
power.Q4SW.10.50.2011 = trend.power.nbinom(diffpct=50, init=mu.Q4SW, k=k.Q4SW, mu=mu.Q4SW, nsamples=nsamples.2011, npower=500, nyears=10, nreps=200)
power.Q4SW.10.40.2011 = trend.power.nbinom(diffpct=40, init=mu.Q4SW, k=k.Q4SW, mu=mu.Q4SW, nsamples=nsamples.2011, npower=500, nyears=10, nreps=200)
power.Q4SW.10.30.2011 = trend.power.nbinom(diffpct=30, init=mu.Q4SW, k=k.Q4SW, mu=mu.Q4SW, nsamples=nsamples.2011, npower=500, nyears=10, nreps=200)
power.Q4SW.10.20.2011 = trend.power.nbinom(diffpct=20, init=mu.Q4SW, k=k.Q4SW, mu=mu.Q4SW, nsamples=nsamples.2011, npower=500, nyears=10, nreps=200)
power.Q4SW.10.10.2011 = trend.power.nbinom(diffpct=10, init=mu.Q4SW, k=k.Q4SW, mu=mu.Q4SW, nsamples=nsamples.2011, npower=500, nyears=10, nreps=200)



#***********************************************************************
#***********************************************************************
# BASELINE
# They want to have some baseline values against which to compare litter
# levels. I could give them the stratified values together with a 95%
# confidence interval. I could also say what they are based on simply
# using the IBTS and Q4SW surveys
#***********************************************************************
litter.km2.Q4SW.1011 = litter.km2[survey=='IBTS' & (year==2010 | year==2011)]
litter.km2.IBTS.1011 = litter.km2[survey=='Q4SW' & (year==2010 | year==2011)]
par(mfrow=c(2,1))
hist(litter.km2.IBTS.1011); hist(litter.km2.Q4SW.1011)

Q4SW.1011.km2.mean = mean(litter.km2.Q4SW.1011)
IBTS.1011.km2.mean = mean(litter.km2.IBTS.1011)

Q4SW.1011.km2.sd = sd(litter.km2.Q4SW.1011)
IBTS.1011.km2.sd = sd(litter.km2.IBTS.1011)

IBTS.1011.km2.mean; Q4SW.1011.km2.mean
IBTS.1011.km2.sd; Q4SW.1011.km2.sd

# Check confirms that conventional confidence intervals are similar
# to bootstrap - but use bootstrap ones
#int = 2*IBTS.1011.km2.sd/sqrt(length(litter.km2.IBTS.1011))
#IBTS.1011.km2.mean - int
#IBTS.1011.km2.mean + int

#
# Bootstrap confidence intervals for the individual surveys
#
bootstrap(litter.km2.Q4SW.1011)
bootstrap(litter.km2.IBTS.1011)


bootstrap = function(X,alpha=0.05,nreps=1000) {
#******************************************************************************
# Calculates three different types of confidence interval for the population mean:
# Standard;
# Percentile;
# Bias corrected 100(1-alpha).
#
# Text used is Bryan F J Manly (1998) , Randomization, Bootstrap and Monte Carlo Methods in
# Biology, 2nd edition, Chapman and Hall.
#******************************************************************************
#
lenX = length(X)
Xmean = rep(0,nreps)
Xstan = rep(0,nreps)
#boot=matrix(0,nrow=nreps,ncol=lenX)
#
# Generate the bootstrap samples and store them in boot[,]
#
for (j in 1:nreps) {
boot = sample(X,lenX,replace=T)
Xmean[j] = mean(boot)
}
boot.mean = mean(Xmean)
boot.stan = sd(Xmean)
#
# standard confidence interval
#
zalpha = qnorm(1-(alpha/2))
upper.stan = boot.mean + zalpha*boot.stan
lower.stan = boot.mean - zalpha*boot.stan
#
# percentile confidence interval
# I have left out the standard 0.5 correction for percentiles as this
# correction shouldnt be needed as nreps gets big
#
sort.mean = sort(Xmean)
i.lower = round(nreps*alpha/2)
i.upper = round(nreps*(1-(alpha/2)))
upper.per = sort.mean[i.upper]
lower.per = sort.mean[i.lower]
#
# Bias-corrected method
#
# Find proportion of time that bootstrap mean exceeds sample mean
#
diff = Xmean - mean(X)
p.exceed = length(diff[diff > 0])/nreps
#
# calculate value of standard normal (x0) that is exceeded with prob p
#
z0 = qnorm(p.exceed)
upper.bias = sort.mean[round(pnorm(2*z0 + zalpha) * nreps)]
lower.bias = sort.mean[round(pnorm(2*z0 - zalpha) * nreps)]
list(standard=c(lower.stan,upper.stan),percentile=c(lower.per,upper.per),bias=c(lower.bias,upper.bias))
}



